/*
 * Decompiled with CFR 0.152.
 */
package jphase.generator;

import java.util.Random;
import jphase.AbstractDiscPhaseVar;
import jphase.generator.GeneratorUtils;
import jphase.generator.PhaseGenerator;

public class NeutsDiscPHGenerator
extends PhaseGenerator {
    double[] alphaDist;
    int[] alphaAlias;
    double[] alphaCutoff;
    double[][] matrixDist;
    int[][] matrixAlias;
    double[][] matrixCutoff;
    Random rand;

    public NeutsDiscPHGenerator(AbstractDiscPhaseVar var) {
        super(var);
    }

    @Override
    public double getRandom() {
        double x = 0.0;
        boolean absorbed = false;
        int estado = GeneratorUtils.getNumber(this.alphaDist, this.alphaAlias, this.alphaCutoff, this.rand);
        if (estado == 0) {
            absorbed = true;
        }
        while (!absorbed) {
            x += 1.0;
            if ((estado = GeneratorUtils.getNumber(this.matrixDist[estado - 1], this.matrixAlias[estado - 1], this.matrixCutoff[estado - 1], this.rand)) != 0) continue;
            absorbed = true;
        }
        return x;
    }

    @Override
    public double[] getRandom(int num) {
        double[] numbers = new double[num];
        int i = 0;
        while (i < num) {
            numbers[i] = this.getRandom();
            ++i;
        }
        return numbers;
    }

    @Override
    protected void initialize() {
        this.rand = new Random();
        int n = this.var.getNumPhases();
        this.alphaDist = new double[n + 1];
        this.alphaAlias = new int[n + 1];
        this.alphaCutoff = new double[n + 1];
        this.matrixDist = new double[n][n + 1];
        this.matrixAlias = new int[n][n + 1];
        this.matrixCutoff = new double[n][n + 1];
        int i = 0;
        while (i < n) {
            this.alphaDist[i + 1] = this.var.getVector().get(i);
            ++i;
        }
        this.alphaDist[0] = 1.0 - Math.min(GeneratorUtils.sum(this.alphaDist), 1.0);
        GeneratorUtils.aliasCut(this.alphaDist, this.alphaAlias, this.alphaCutoff);
        int j = 0;
        while (j < n) {
            int i2 = 0;
            while (i2 < n) {
                this.matrixDist[j][i2 + 1] = this.var.getMatrix().get(j, i2);
                ++i2;
            }
            this.matrixDist[j][0] = 1.0 - Math.min(GeneratorUtils.sum(this.matrixDist[j]), 1.0);
            GeneratorUtils.aliasCut(this.matrixDist[j], this.matrixAlias[j], this.matrixCutoff[j]);
            ++j;
        }
    }
}

