/*
 * Decompiled with CFR 0.152.
 */
package jphase.fit;

import jphase.ContPhaseVar;
import jphase.DenseContPhaseVar;
import jphase.fit.FitterUtils;
import jphase.fit.MomentsContPhaseFitter;
import jphase.fit.MomentsECCompleteFit;

public class MomentsECPositiveFit
extends MomentsContPhaseFitter {
    private static double precision = 1.0E-5;

    public MomentsECPositiveFit(double[] data) {
        super(data);
    }

    public MomentsECPositiveFit(double m1, double m2, double m3) {
        super(m1, m2, m3);
    }

    @Override
    public ContPhaseVar fit() {
        System.out.println("m1: " + this.m1);
        System.out.println("m2: " + this.m2);
        System.out.println("m3: " + this.m3);
        try {
            double[] param = this.getParam();
            DenseContPhaseVar EC = DenseContPhaseVar.ErlangCoxian((int)param[0], param[1], param[2], param[3], param[4], param[5]);
            int n = param.length;
            if (n == 7) {
                return EC.sum(DenseContPhaseVar.expo(param[6]), new DenseContPhaseVar((int)param[0] + 1));
            }
            return EC.mix(param[6], DenseContPhaseVar.expo(param[7]), new DenseContPhaseVar((int)param[0] + 1));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private boolean inU(double m2, double m3) {
        if (m3 <= 2.0 * m2 + 1.0 || m2 > 2.0 || m2 < 1.0) {
            return false;
        }
        int i = 1;
        while (i < 1000) {
            double limInf = ((double)i + 2.0) / ((double)i + 1.0);
            double limSup = ((double)i + 1.0) / (double)i;
            if (limInf < m2 && m2 < limSup) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public double[] getParam() throws IllegalArgumentException {
        double n2 = this.m2 / (this.m1 * this.m1);
        double n3 = this.m3 / (this.m1 * this.m2);
        double r = n3 / n2;
        if (n2 > 1.0 && n3 > n2) {
            if (this.inU(n2, n3) || n3 == 2.0 * n2 - 1.0 || r != 1.5 && n3 < 2.0 * n2 - 1.0) {
                if (r < 1.5 && r < 1.5) {
                    double k = FitterUtils.floor((2.0 * n2 - n3) / (n3 - n2), precision);
                    if (n3 >= ((k + 1.0) * n2 + (k + 4.0)) / (2.0 * (k + 2.0)) * n2) {
                        System.out.println("m3 >= ((k+1)*m2 + (k+4))/(2*(k+2)) * m2");
                        double[] param = new double[8];
                        double[] paramComplete = new double[6];
                        double w = (2.0 - n2) / (4.0 * (1.5 - r));
                        double a = (2.0 - n2) * (2.0 - n2);
                        double pMix = a / (a + 4.0 * (2.0 * n2 - 1.0 - n3));
                        double m1X = this.m1 / (pMix + (1.0 - pMix) * w);
                        double m2X = 2.0 * w;
                        double m3X = 2.0 * m2X - 1.0;
                        double lambda = 1.0 / (w * m1X);
                        MomentsECCompleteFit complete = new MomentsECCompleteFit(m1X, m2X * m1X * m1X, m3X * m1X * m2X);
                        paramComplete = complete.getParam();
                        System.arraycopy(paramComplete, 0, param, 0, 6);
                        param[6] = lambda;
                        param[7] = pMix;
                        return param;
                    }
                    if (n3 < ((k + 1.0) * n2 + (k + 4.0)) / (2.0 * (k + 2.0)) * n2 && Math.abs(n2 - 2.0) <= precision) {
                        System.out.println("m3 < ((k+1)*m2 + (k+4))/(2*(k+2))*m2  AND m2 = 2");
                        double[] param = new double[7];
                        double[] paramComplete = new double[6];
                        double z = (n3 - 2.0 * (k + 3.0) / (k + 2.0)) / (3.0 - n3);
                        double m1X = this.m1 / (1.0 + z);
                        double m2X = 2.0 * (1.0 + z);
                        double m3X = (k + 3.0) / (k + 2.0) * m2X;
                        double lambda = 1.0 / (z * m1X);
                        MomentsECCompleteFit complete = new MomentsECCompleteFit(m1X, m2X * m1X * m1X, m3X * m1X * m2X);
                        paramComplete = complete.getParam();
                        System.arraycopy(paramComplete, 0, param, 0, 6);
                        param[6] = lambda;
                        return param;
                    }
                    System.out.println("m3 < ((k+1)*m2 + (k+4))/(2*(k+2))*m2  AND m2 != 2");
                    double[] param = new double[7];
                    double[] paramComplete = new double[6];
                    double a = 2.0 * (k + 3.0) / (k + 2.0) * (n2 - 2.0);
                    double z = (n2 * (n3 - 3.0 - a) + n2 * FitterUtils.sqrt((n3 - 3.0) * (n3 - 3.0) + 4.0 * a * (1.5 - r), precision)) / (a * (n2 - 2.0));
                    double m1X = this.m1 / (1.0 + z);
                    double m2X = (1.0 + z) * (n2 * (1.0 + z) - 2.0 * z);
                    double m3X = (k + 3.0) / (k + 2.0) * m2X;
                    double lambda = 1.0 / (z * m1X);
                    MomentsECCompleteFit complete = new MomentsECCompleteFit(m1X, m2X * m1X * m1X, m3X * m1X * m2X);
                    paramComplete = complete.getParam();
                    System.arraycopy(paramComplete, 0, param, 0, 6);
                    param[6] = lambda;
                    return param;
                }
                double[] param = new double[6];
                MomentsECCompleteFit complete = new MomentsECCompleteFit(this.m1, n2, n3);
                param = complete.getParam();
                return param;
            }
            throw new IllegalArgumentException("The set of moments is not in the set   U || m3 == 2*m2-1 || (r != 1.5 && m3 < 2*m2 - 1)");
        }
        throw new IllegalArgumentException("The set of moments is not representable by the PH type distributions\n It is not in m2 > 1 AND m3 > m2");
    }
}

