/*
 * Decompiled with CFR 0.152.
 */
package jphase.fit;

import jphase.ContPhaseVar;
import jphase.DenseContPhaseVar;
import jphase.fit.FitterUtils;
import jphase.fit.MomentsContPhaseFitter;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;

public class MomentsECCompleteFit
extends MomentsContPhaseFitter {
    private static double precision = 1.0E-5;

    public MomentsECCompleteFit(double[] data) {
        super(data);
    }

    public MomentsECCompleteFit(double m1, double m2, double m3) {
        super(m1, m2, m3);
    }

    @Override
    public ContPhaseVar fit() {
        System.out.println("m1: " + this.m1);
        System.out.println("m2: " + this.m2);
        System.out.println("m3: " + this.m3);
        double[] param = this.getParam();
        if (param[4] == 0.0 && param[5] == 0.0) {
            DenseContPhaseVar var = (DenseContPhaseVar)DenseContPhaseVar.Erlang(param[2], (int)param[0] - 2).sum(DenseContPhaseVar.expo(param[3]), new DenseContPhaseVar((int)param[0] - 1));
            double[] initCond = new double[(int)param[0] - 1];
            initCond[0] = param[1];
            var.setVector((Vector)new DenseVector(initCond));
            return var;
        }
        return DenseContPhaseVar.ErlangCoxian((int)param[0], param[1], param[2], param[3], param[4], param[5]);
    }

    public double[] getParam() {
        double[] param = new double[6];
        double n2 = this.m2 / (this.m1 * this.m1);
        double n3 = this.m3 / (this.m1 * this.m2);
        if (n2 <= 1.0 || n3 <= n2) {
            System.out.println("Second or Third Moment non Feasible (too little) " + n3 + " (0.5<=Cx^2<=1");
            return param;
        }
        if (n3 > 2.0 * n2 - 1.0 && Math.abs((double)((int)(1.0 / (n2 - 1.0))) - 1.0 / (n2 - 1.0)) <= precision) {
            System.out.println("m3 > 2*m2 -1 and 1/(m2-1) isInteger");
            param[1] = (n2 * n2 + 2.0 * n2 - 1.0) / (2.0 * n2 * n2);
        } else if (n3 < 2.0 * n2 - 1.0) {
            System.out.println("m3 < 2*m2 -1");
            param[1] = 1.0 / (2.0 * n2 - n3);
        } else {
            System.out.println("m3 = 2*m2 -1 or m3 > 2*m2 -1 and 1/(m2-1) is NOT Integer");
            param[1] = 1.0;
        }
        double m1W = this.m1 / param[1];
        double m2W = param[1] * n2;
        double m3W = param[1] * n3;
        if (m3W == 2.0 * m2W - 1.0 && m2W <= 2.0) {
            System.out.println("m3W ==2*m2W-1 and m2W <= 2");
            param[0] = FitterUtils.ceil(m2W / (m2W - 1.0), precision) - 1.0;
        } else {
            System.out.println("m3W != 2*m2W-1 or m2W > 2");
            param[0] = FitterUtils.floor(m2W / (m2W - 1.0) + 1.0, precision);
        }
        if (param[0] == 1.0) {
            param[2] = 0.0;
            param[3] = 1.0 / m1W;
            param[4] = 0.0;
            param[5] = 0.0;
            return param;
        }
        int n = (int)param[0];
        double m2X = ((double)(n - 3) * m2W - (double)(n - 2)) / ((double)(n - 2) * m2W - (double)(n - 1));
        double m1X = m1W / ((double)(n - 2) * m2X - (double)(n - 3));
        double alpha = (double)(n - 2) * (m2X - 1.0) * ((double)(n * (n - 1)) * m2X * m2X - (double)(n * (2 * n - 5)) * m2X + (double)((n - 1) * (n - 3)));
        double beta = ((double)(n - 1) * m2X - (double)(n - 2)) * ((double)(n - 2) * m2X - (double)(n - 3)) * ((double)(n - 2) * m2X - (double)(n - 3));
        double m3X = (beta * m3W - alpha) / m2X;
        double u = 0.0;
        double v = 0.0;
        if (Math.abs(3.0 * m2X - 2.0 * m3X) < 0.01) {
            System.out.println("3*m2X == 2*m3X");
            u = 1.0;
            v = 0.0;
        } else {
            System.out.println("3*m2X != 2*m3X");
            u = (6.0 - 2.0 * m3X) / (3.0 * m2X - 2.0 * m3X);
            v = (12.0 - 6.0 * m2X) / (m2X * (3.0 * m2X - 2.0 * m3X));
        }
        param[2] = 1.0 / (m1X * (m2X - 1.0));
        param[3] = (u + FitterUtils.sqrt(u * u - 4.0 * v, precision)) / (2.0 * m1X);
        param[4] = (u - FitterUtils.sqrt(u * u - 4.0 * v, precision)) / (2.0 * m1X);
        param[5] = param[4] * (param[3] * m1X - 1.0) / param[3];
        return param;
    }
}

