/*
 * Decompiled with CFR 0.152.
 */
package jphase.fit;

import jphase.ContPhaseVar;
import jphase.DenseContPhaseVar;
import jphase.fit.MomentsContPhaseFitter;

public class MomentsACPH2Fit
extends MomentsContPhaseFitter {
    public static double precision = 1.0E-5;

    public MomentsACPH2Fit(double[] data) {
        super(data);
    }

    public MomentsACPH2Fit(double m1, double m2, double m3) {
        super(m1, m2, m3);
    }

    @Override
    public ContPhaseVar fit() {
        double[] param = this.getParam(this.m1, this.m2, this.m3);
        double[] vector = new double[]{param[0], 1.0 - param[0]};
        double[][] matriz = new double[2][2];
        matriz[0][0] = -param[1];
        matriz[0][1] = param[1];
        matriz[1][1] = -param[2];
        return new DenseContPhaseVar(vector, matriz);
    }

    private double[] getParam(double m1, double m2, double m3) {
        double[] param = new double[3];
        double cx2 = m2 / (m1 * m1) - 1.0;
        double m13 = m1 * m1 * m1;
        if (m1 > 0.0) {
            if (cx2 >= 0.5) {
                if (cx2 <= 1.0) {
                    System.out.println("HypoExponential");
                    if (m3 < 3.0 * m13 * (3.0 * cx2 - 1.0 + Math.sqrt(2.0) * Math.pow(1.0 - cx2, 1.5))) {
                        System.out.println("Third Moment non Feasible (too small) " + m3 + " (0.5<=Cx^2<=1");
                        m3 = 3.0 * m13 * (3.0 * cx2 - 1.0 + Math.sqrt(2.0) * Math.pow(1.0 - cx2, 1.5));
                        System.out.println("Third Moment fixed on " + m3 + " for feasibility");
                    } else if (m3 > 6.0 * m13 * cx2) {
                        System.out.println("Third Moment non Feasible (too large) " + m3 + " (0.5<=Cx^2<=1");
                        m3 = 6.0 * m13 * cx2;
                        System.out.println("Third Moment fixed on " + m3 + " for feasibility");
                    }
                    this.getParamFactible(m1, m2, m3, param);
                } else {
                    System.out.println("HyperExponencial");
                    if (m3 < 1.5 * m13 * (1.0 + cx2) * (1.0 + cx2)) {
                        System.out.println("Third Moment non Feasible (too small) " + m3 + " (Cx^2>=1");
                        m3 = 1.5 * m13 * (1.0 + cx2) * (1.0 + cx2);
                        System.out.println("Third Moment fixed on " + m3 + " for feasibility");
                    }
                    this.getParamFactible(m1, m2, m3, param);
                }
            } else {
                System.out.println("Squared Coefficient of Variance non Feasible " + cx2 + " <0.5");
            }
        } else {
            System.out.println("First moment non feasible " + m1 + " < 0");
        }
        return param;
    }

    private void getParamFactible(double m1, double m2, double m3, double[] param) {
        double d = 2.0 * m1 * m1 - m2;
        double c = 3.0 * m2 * m2 - 2.0 * m1 * m3;
        double b = 3.0 * m1 * m2 - m3;
        double a = b * b - 6.0 * c * d;
        if (Math.abs(c) > precision) {
            if (c > 0.0) {
                System.out.println("c > 0");
                double sqa = Math.sqrt(a);
                param[0] = (-b + 6.0 * m1 * d + sqa) / (b + sqa);
                param[1] = (b - sqa) / c;
                param[2] = (b + sqa) / c;
            } else {
                System.out.println("c < 0");
                double sqa = Math.sqrt(a);
                param[0] = (b - 6.0 * m1 * d + sqa) / (-b + sqa);
                param[1] = (b + sqa) / c;
                param[2] = (b - sqa) / c;
            }
        } else {
            System.out.println("Adjusted to exponential");
            param[0] = 0.0;
            param[2] = 1.0 / m1;
        }
    }
}

