/*
 * Decompiled with CFR 0.152.
 */
package jphase.distributions;

import cern.colt.list.DoubleArrayList;
import java.util.ArrayList;
import jphase.distributions.EDistribution;
import jphase.distributions.IDistribution;
import umontreal.iro.lecuyer.probdist.WeibullDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.randvar.WeibullGen;
import umontreal.iro.lecuyer.rng.RandomStream;

class Weibull
extends EDistribution
implements IDistribution {
    public Weibull(ArrayList<Double> paramatros) {
        double alpha = 0.5;
        double lambda = 1.0;
        double delta = 0.0;
        if (paramatros != null) {
            alpha = paramatros.get(0);
            lambda = paramatros.get(1);
            delta = paramatros.get(2);
        }
        this.generadores = new ArrayList();
        this.generadores.add("WeibulGen");
        this.parametros = new ArrayList();
        this.parametros.add("alpha");
        this.parametros.add("lambda");
        this.parametros.add("delta");
        this.distribucion = new WeibullDist(alpha, lambda, delta);
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String nombre, ArrayList<Double> paramatros) {
        double alpha = 0.5;
        double lambda = 1.0;
        double delta = 0.0;
        if (paramatros != null) {
            alpha = paramatros.get(0);
            lambda = paramatros.get(1);
            delta = paramatros.get(2);
        }
        if (nombre.equals("WeibullGen")) {
            this.generador = new WeibullGen(s, alpha, lambda, delta);
        }
        return this.generador;
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String d) {
        this.generador = new WeibullGen(s, (WeibullDist)this.darDistribucion());
        return this.generador;
    }

    @Override
    public void ajustarParametros(DoubleArrayList data) {
        double[] para = WeibullDist.getMLE((double[])data.elements(), (int)data.size());
        this.distribucion = new WeibullDist(para[0], para[1], para[2]);
    }

    @Override
    public double[] getMoments() {
        double[] mom = new double[]{this.distribucion.getMean(), this.distribucion.getStandardDeviation(), 1.0};
        return mom;
    }

    @Override
    public String aString() {
        WeibullDist dis = (WeibullDist)this.distribucion;
        return "Weibull with alpha: " + this.nSig(dis.getAlpha(), 3) + ", lambda:  " + this.nSig(dis.getLambda(), 3) + ", delta: " + this.nSig(dis.getDelta(), 3);
    }

    @Override
    public String getName() {
        return "Weibull";
    }
}

