/*
 * Decompiled with CFR 0.152.
 */
package jphase.distributions;

import cern.colt.list.DoubleArrayList;
import java.util.ArrayList;
import jphase.distributions.EDistribution;
import jphase.distributions.IDistribution;
import umontreal.iro.lecuyer.probdist.UniformDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.randvar.UniformGen;
import umontreal.iro.lecuyer.rng.RandomStream;

class Uniform
extends EDistribution
implements IDistribution {
    public Uniform(ArrayList<Double> paramatros) {
        double min = 0.0;
        double max = 1.0;
        if (paramatros != null) {
            min = paramatros.get(0);
            max = paramatros.get(1);
        }
        this.generadores = new ArrayList();
        this.generadores.add("UniformGen");
        this.parametros = new ArrayList();
        this.parametros.add("min");
        this.parametros.add("max");
        this.distribucion = new UniformDist(min, max);
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String nombre, ArrayList<Double> paramatros) {
        double min = 0.0;
        double max = 1.0;
        if (paramatros != null) {
            min = paramatros.get(0);
            max = paramatros.get(1);
        }
        if (nombre.equals("UniformGen")) {
            this.generador = new UniformGen(s, min, max);
        }
        return this.generador;
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String d) {
        this.generador = new UniformGen(s, (UniformDist)this.darDistribucion());
        return this.generador;
    }

    @Override
    public void ajustarParametros(DoubleArrayList data) {
        double[] para = UniformDist.getMLE((double[])data.elements(), (int)data.size());
        this.distribucion = new UniformDist(para[0], para[1]);
    }

    @Override
    public double[] getMoments() {
        double[] mom = new double[]{this.distribucion.getMean(), this.distribucion.getStandardDeviation(), 0.0};
        return mom;
    }

    @Override
    public String aString() {
        UniformDist dis = (UniformDist)this.distribucion;
        return "Uniforme with min: " + this.nSig(dis.getA(), 3) + ", max:  " + this.nSig(dis.getB(), 3);
    }

    @Override
    public String getName() {
        return "Uniform";
    }
}

