/*
 * Decompiled with CFR 0.152.
 */
package jphase.distributions;

import cern.colt.list.DoubleArrayList;
import java.util.ArrayList;
import jphase.distributions.EDistribution;
import jphase.distributions.IDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.randvar.GammaGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

class Gamma
extends EDistribution
implements IDistribution {
    public Gamma(ArrayList<Double> paramatros) {
        double alpha = 0.5;
        double lambda = 0.5;
        if (paramatros != null) {
            alpha = paramatros.get(0);
            lambda = paramatros.get(1);
        }
        this.generadores = new ArrayList();
        this.generadores.add("GammaGen");
        this.parametros = new ArrayList();
        this.parametros.add("alpha");
        this.parametros.add("lambda");
        this.distribucion = new GammaDist(alpha, lambda);
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String nombre, ArrayList<Double> paramatros) {
        double alpha = 0.5;
        double lambda = 0.5;
        if (paramatros != null) {
            alpha = paramatros.get(0);
            lambda = paramatros.get(1);
        }
        if (nombre.equals("GammaGen")) {
            this.generador = new GammaGen(s, alpha, lambda);
        }
        return this.generador;
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String d) {
        this.generador = new GammaGen(s, (GammaDist)this.darDistribucion());
        return this.generador;
    }

    @Override
    public void ajustarParametros(DoubleArrayList data) {
        double[] para = GammaDist.getMLE((double[])data.elements(), (int)data.size());
        this.distribucion = new GammaDist(para[0], para[1]);
    }

    @Override
    public double[] getMoments() {
        double[] mom = new double[]{this.distribucion.getMean(), this.distribucion.getStandardDeviation(), 2.0 / Math.sqrt(((GammaDist)this.distribucion).getAlpha())};
        return mom;
    }

    @Override
    public String aString() {
        GammaDist dis = (GammaDist)this.distribucion;
        return "Gamma with alpha: " + this.nSig(dis.getAlpha(), 3) + ", lambda:  " + this.nSig(dis.getLambda(), 3);
    }

    @Override
    public String getName() {
        return "Gamma";
    }
}

