/*
 * Decompiled with CFR 0.152.
 */
package jphase.distributions;

import cern.colt.list.DoubleArrayList;
import java.util.ArrayList;
import jphase.distributions.EDistribution;
import jphase.distributions.IDistribution;
import umontreal.iro.lecuyer.probdist.ExponentialDist;
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

class Exponential
extends EDistribution
implements IDistribution {
    public Exponential(ArrayList<Double> paramatros) {
        double lambda = 1.0;
        if (paramatros != null) {
            lambda = paramatros.get(0);
        }
        this.generadores = new ArrayList();
        this.generadores.add("ExponentialGen");
        this.parametros = new ArrayList();
        this.parametros.add("lambda");
        this.distribucion = new ExponentialDist(lambda);
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String nombre, ArrayList<Double> paramatros) {
        double lambda = 1.0;
        if (paramatros != null) {
            lambda = paramatros.get(0);
        }
        if (nombre.equals("ExponentialGen")) {
            this.generador = new ExponentialGen(s, lambda);
        }
        return this.generador;
    }

    @Override
    public RandomVariateGen darGenerador(RandomStream s, String d) {
        this.generador = new ExponentialGen(s, (ExponentialDist)this.darDistribucion());
        return this.generador;
    }

    @Override
    public void ajustarParametros(DoubleArrayList data) {
        double[] para = ExponentialDist.getMLE((double[])data.elements(), (int)data.size());
        this.distribucion = new ExponentialDist(para[0]);
    }

    @Override
    public double[] getMoments() {
        double[] mom = new double[]{this.distribucion.getMean(), this.distribucion.getStandardDeviation(), 2.0};
        return mom;
    }

    @Override
    public String aString() {
        ExponentialDist dis = (ExponentialDist)this.distribucion;
        return "Exponencial with lambda:  " + this.nSig(dis.getLambda(), 3);
    }

    @Override
    public String getName() {
        return "Exponential";
    }
}

