/*
 * Decompiled with CFR 0.152.
 */
package jphase.distributions;

import java.util.ArrayList;
import jphase.distributions.IDistribution;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYSeries;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;

public abstract class EDistribution
implements IDistribution {
    public ContinuousDistribution distribucion;
    public ArrayList<String> generadores;
    public ArrayList<String> parametros;
    public RandomVariateGen generador;

    public String toString() {
        return this.distribucion.toString();
    }

    @Override
    public ArrayList<String> darParametros() {
        return this.parametros;
    }

    @Override
    public ContinuousDistribution darDistribucion() {
        return this.distribucion;
    }

    @Override
    public RandomVariateGen darGenerador() {
        return this.generador;
    }

    @Override
    public ArrayList<String> darGeneradores() {
        return this.generadores;
    }

    public double nSig(double valor, int cifSignifica) {
        double pow = Math.pow(10.0, cifSignifica);
        double ret = (double)((int)(valor * pow)) / pow;
        return ret;
    }

    @Override
    public DefaultTableXYDataset getPDF(double a, double b, int m) {
        XYSeries dataPDF = new XYSeries((Comparable)((Object)(String.valueOf(this.getName()) + " (PDF)")), true, false);
        double dif = (b - a) / (double)m;
        int i = 0;
        while (i != m) {
            double point = a + (double)i * dif;
            double pdf = this.distribucion.density(point);
            dataPDF.add(point, pdf);
            ++i;
        }
        DefaultTableXYDataset datasetPDF = new DefaultTableXYDataset();
        datasetPDF.addSeries(dataPDF);
        return datasetPDF;
    }
}

