/*
 * Decompiled with CFR 0.152.
 */
package jphase;

public class Utils {
    private static double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static double[] a = new double[101];
    private static double[][] B = new double[33][33];
    private static long[][] Pers = new long[33][33];
    private static double[] fac = new double[33];
    private static int topN = 0;

    public static double lnPermut(int n, int k) {
        if (k > n) {
            throw new IllegalArgumentException("wrong parameters for permutation function");
        }
        if (n <= 32 && k <= 32) {
            return B[n][k] != 0.0 ? B[n][k] : (Utils.B[n][k] = Utils.lnFactorial(n) - Utils.lnFactorial(n - k));
        }
        return Utils.lnFactorial(n) - Utils.lnFactorial(n - k);
    }

    public static double permut(int n, int k) {
        if (k > n && n < 0) {
            throw new IllegalArgumentException("wrong parameters for permutation function");
        }
        if (n <= 32 && k <= 32) {
            if (Pers[n][k] != 0L) {
                return Pers[n][k];
            }
            long mult = 1L;
            int m = n;
            int i = 0;
            while (i < k) {
                mult *= (long)m--;
                ++i;
            }
            long l = mult;
            Utils.Pers[n][k] = l;
            return l;
        }
        return (long)Math.floor(0.5 + Math.exp(Utils.lnPermut(n, k)));
    }

    public static double lnGamma(double xx) {
        double x;
        double y = x = xx;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        int j = 0;
        while (j <= 5) {
            ser += cof[j] / (y += 1.0);
            ++j;
        }
        return (float)(-tmp + Math.log(2.506628274631005 * ser / x));
    }

    public static double lnFactorial(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative factorial");
        }
        if (n <= 1) {
            return 0.0;
        }
        if (n <= 32) {
            return a[n] != 0.0 ? a[n] : Math.log(Utils.fact(n));
        }
        if (n <= 100) {
            return a[n] != 0.0 ? a[n] : Utils.lnGamma((double)n + 1.0);
        }
        return Utils.lnGamma((double)n + 1.0);
    }

    /*
     * Unable to fully structure code
     */
    public static double fact(int n) {
        Utils.fac[0] = 1.0;
        if (n < 0) {
            throw new ArithmeticException("Negative factorial");
        }
        if (n <= 32) ** GOTO lbl7
        return Math.exp(Utils.lnGamma((double)n + 1.0));
lbl-1000:
        // 1 sources

        {
            Utils.fac[++Utils.topN] = Utils.fac[j] * (double)Utils.topN;
lbl7:
            // 2 sources

            ** while (Utils.topN < n)
        }
lbl8:
        // 1 sources

        return Utils.fac[n];
    }

    public static double gammaP(double a, double x) {
        if (x < 0.0 || a <= 0.0) {
            throw new IllegalArgumentException("Incorrect arguments for incomplete gamma function ");
        }
        if (x < a + 1.0) {
            return Utils.gammaSeries(a, x);
        }
        return 1.0 - Utils.gammaContFrac(a, x);
    }

    private static double gammaSeries(double a, double x) {
        double sum;
        double gln = Utils.lnGamma(a);
        int ITMAX = 100;
        double EPS = 3.0E-7;
        if (x < 0.0) {
            throw new IllegalArgumentException("x less than 0 in gammaSeies");
        }
        if (x == 0.0) {
            return 0.0;
        }
        double ap = a;
        double del = sum = 1.0 / a;
        int n = 0;
        while (n <= 100) {
            sum += (del *= x / (ap += 1.0));
            if (Math.abs(del) < Math.abs(sum) * 3.0E-7) {
                return sum * Math.exp(-x + a * Math.log(x) - gln);
            }
            ++n;
        }
        throw new ArithmeticException("ITMAX too small, or a to large in routine gammaSeries");
    }

    private static double gammaContFrac(double a, double x) {
        double d;
        int ITMAX = 500;
        double EPS = 3.0E-7;
        double MIND = 4.9406564584124654E-304;
        double gln = Utils.lnGamma(a);
        double b = x + 1.0 - a;
        double c = 2.024022533073106E303;
        double h = d = 1.0 / b;
        int i = 1;
        while (i <= 500) {
            double an = (double)(-i) * ((double)i - a);
            if (Math.abs(d = an * d + (b += 2.0)) < 4.9406564584124654E-304) {
                d = 4.9406564584124654E-304;
            }
            if (Math.abs(c = b + an / c) < 4.9406564584124654E-304) {
                c = 4.9406564584124654E-304;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) < 3.0E-7) break;
            ++i;
        }
        if (i > 500) {
            throw new ArithmeticException("ITMAX too small, a too large in gammaContFrac");
        }
        return Math.exp(-x + a * Math.log(x) - gln) * h;
    }

    public static double binomial(int n, int k) {
        return Math.floor(0.5 + Math.exp(Utils.lnFactorial(n) - Utils.lnFactorial(k) - Utils.lnFactorial(n - k)));
    }

    public static double lnBinomial(int n, int k) {
        return Utils.lnFactorial(n) - Utils.lnFactorial(k) - Utils.lnFactorial(n - k);
    }

    public static double pow(double x, int n) {
        double mult = 1.0;
        if (n < 0) {
            n = -n;
            x = 1.0 / x;
        }
        int i = 1;
        while (i <= n) {
            mult *= x;
            ++i;
        }
        return mult;
    }

    public static double distance(double[] v1, double[] v2) {
        int n = v1.length;
        if (n != v2.length) {
            return -1.0;
        }
        double maxi = -1.0;
        int i = 0;
        while (i < n) {
            double del2 = v1[i] - v2[i];
            double del = v1[i] > 0.0 ? del2 / v1[i] : del2;
            maxi = Math.max(maxi, del * del);
            ++i;
        }
        return Math.sqrt(maxi);
    }

    public static double[][] initUpperTriangular(int n) {
        double[][] mati = new double[n][];
        int i = 0;
        while (i < n) {
            mati[i] = new double[n - i];
            ++i;
        }
        return mati;
    }
}

