/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import jphase.SparseContPhaseVar;
import jphase.SparseDiscPhaseVar;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public class SparseContClosureTest
extends TestCase {
    SparseContPhaseVar var1;
    SparseContPhaseVar var2;
    SparseDiscPhaseVar varD;
    double[][] matrix1 = new double[][]{{-2.0, 2.0}, {2.0, -5.0}};
    double[][] matrix2 = new double[][]{{-4.0, 2.0, 1.0}, {1.0, -3.0, 1.0}, {2.0, 1.0, -5.0}};
    double[][] matrixD = new double[][]{{0.76, 0.24}, {0.0, 0.76}};
    double[] vector1 = new double[]{0.2, 0.4};
    double[] vector2 = new double[]{0.1, 0.2, 0.2};
    double[] vectorD = new double[]{0.15, 0.85};

    public static void main(String[] args) {
        TestRunner.run(SparseContClosureTest.class);
    }

    protected void setUp() throws Exception {
        this.var1 = new SparseContPhaseVar(this.vector1, this.matrix1);
        this.var2 = new SparseContPhaseVar(this.vector2, this.matrix2);
        this.varD = new SparseDiscPhaseVar(this.vectorD, this.matrixD);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSum() {
        SparseContPhaseVar calcSum = (SparseContPhaseVar)this.var1.sum(this.var2);
        double[] vecRes = new double[]{0.2, 0.4, 0.04, 0.08, 0.08};
        double[][] matRes = new double[][]{{-2.0, 2.0, 0.0, 0.0, 0.0}, {2.0, -5.0, 0.3, 0.6, 0.6}, {0.0, 0.0, -4.0, 2.0, 1.0}, {0.0, 0.0, 1.0, -3.0, 1.0}, {0.0, 0.0, 2.0, 1.0, -5.0}};
        SparseContPhaseVar realSum = new SparseContPhaseVar(vecRes, matRes);
        SparseContClosureTest.assertTrue((String)"Sum of Variables non equal (Matrix)", (realSum.getMatrix().add(-1.0, calcSum.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Sum of Variables non equal (Vector)", (realSum.getVector().add(-1.0, calcSum.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix1).add(-1.0, this.var1.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector1).add(-1.0, this.var1.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix2).add(-1.0, this.var2.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector2).add(-1.0, this.var2.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testMin() {
        SparseContPhaseVar calcSum = (SparseContPhaseVar)this.var1.min(this.var2);
        double[] vecRes = new double[]{0.02, 0.04, 0.04, 0.04, 0.08, 0.08};
        double[][] matRes = new double[][]{{-6.0, 2.0, 1.0, 2.0, 0.0, 0.0}, {1.0, -5.0, 1.0, 0.0, 2.0, 0.0}, {2.0, 1.0, -7.0, 0.0, 0.0, 2.0}, {2.0, 0.0, 0.0, -9.0, 2.0, 1.0}, {0.0, 2.0, 0.0, 1.0, -8.0, 1.0}, {0.0, 0.0, 2.0, 2.0, 1.0, -10.0}};
        SparseContPhaseVar realSum = new SparseContPhaseVar(vecRes, matRes);
        SparseContClosureTest.assertTrue((String)"Min of Variables non equal (Matrix)", (realSum.getMatrix().add(-1.0, calcSum.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Min of Variables non equal (Vector)", (realSum.getVector().add(-1.0, calcSum.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix1).add(-1.0, this.var1.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector1).add(-1.0, this.var1.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix2).add(-1.0, this.var2.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector2).add(-1.0, this.var2.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testMax() {
        SparseContPhaseVar calcSum = (SparseContPhaseVar)this.var1.max(this.var2);
        double[] vecRes = new double[]{0.02, 0.04, 0.04, 0.04, 0.08, 0.08, 0.1, 0.2, 0.04, 0.08, 0.08};
        double[][] matRes = new double[][]{{-6.0, 2.0, 1.0, 2.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {1.0, -5.0, 1.0, 0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 1.0, -7.0, 0.0, 0.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 0.0, 0.0, -9.0, 2.0, 1.0, 0.0, 1.0, 3.0, 0.0, 0.0}, {0.0, 2.0, 0.0, 1.0, -8.0, 1.0, 0.0, 1.0, 0.0, 3.0, 0.0}, {0.0, 0.0, 2.0, 2.0, 1.0, -10.0, 0.0, 2.0, 0.0, 0.0, 3.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.0, 2.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, -5.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -4.0, 2.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, -3.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 1.0, -5.0}};
        SparseContPhaseVar realSum = new SparseContPhaseVar(vecRes, matRes);
        SparseContClosureTest.assertTrue((String)"Max of Variables non equal (Matrix)", (realSum.getMatrix().add(-1.0, calcSum.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Max of Variables non equal (Vector)", (realSum.getVector().add(-1.0, calcSum.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix1).add(-1.0, this.var1.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector1).add(-1.0, this.var1.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix2).add(-1.0, this.var2.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector2).add(-1.0, this.var2.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testMix() {
        SparseContPhaseVar calc = (SparseContPhaseVar)this.var1.mix(0.2, this.var2);
        double[] vecRes = new double[]{0.04, 0.08, 0.08, 0.16, 0.16};
        double[][] matRes = new double[][]{{-2.0, 2.0, 0.0, 0.0, 0.0}, {2.0, -5.0, 0.0, 0.0, 0.0}, {0.0, 0.0, -4.0, 2.0, 1.0}, {0.0, 0.0, 1.0, -3.0, 1.0}, {0.0, 0.0, 2.0, 1.0, -5.0}};
        SparseContPhaseVar real = new SparseContPhaseVar(vecRes, matRes);
        SparseContClosureTest.assertTrue((String)"Mix of Variables non equal (Matrix)", (real.getMatrix().add(-1.0, calc.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Mix of Variables non equal (Vector)", (real.getVector().add(-1.0, calc.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix1).add(-1.0, this.var1.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector1).add(-1.0, this.var1.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix2).add(-1.0, this.var2.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector2).add(-1.0, this.var2.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testSumGeom() {
        SparseContPhaseVar calc = (SparseContPhaseVar)this.var2.sumGeom(0.2);
        double[] vecRes = new double[]{0.1, 0.2, 0.2};
        double[][] matRes = new double[][]{{-3.92, 2.16, 1.16}, {1.08, -2.84, 1.16}, {2.16, 1.32, -4.68}};
        SparseContPhaseVar real = new SparseContPhaseVar(vecRes, matRes);
        SparseContClosureTest.assertTrue((String)"Geometric Sum of Variables non equal (Matrix)", (real.getMatrix().add(-1.0, calc.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Geometric Sum of Variables non equal (Vector)", (real.getVector().add(-1.0, calc.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix2).add(-1.0, this.var2.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector2).add(-1.0, this.var2.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testResidual() {
        SparseContPhaseVar calc = (SparseContPhaseVar)this.var2.residualTime(2.0);
        double[] vecRes = new double[]{0.318884557, 0.472382406, 0.208733037};
        SparseContPhaseVar real = new SparseContPhaseVar(vecRes, this.var2.getMatrixArray());
        SparseContClosureTest.assertTrue((String)"Residual Time Distribution non equal (Vector)", (real.getVector().add(-1.0, calc.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix2).add(-1.0, this.var2.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector2).add(-1.0, this.var2.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testEqResidual() {
        SparseContPhaseVar calc = (SparseContPhaseVar)this.var2.eqResidualTime();
        double[] vecRes = new double[]{0.3, 0.45, 0.25};
        SparseContPhaseVar real = new SparseContPhaseVar(vecRes, this.var2.getMatrixArray());
        SparseContClosureTest.assertTrue((String)"Equilibrium Residual Time Distribution non equal (Vector)", (real.getVector().add(-1.0, calc.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix2).add(-1.0, this.var2.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector2).add(-1.0, this.var2.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testWaitingQ() {
        SparseContPhaseVar calc = (SparseContPhaseVar)this.var2.waitingQ(0.5);
        double[] vecRes = new double[]{0.15, 0.225, 0.125};
        double[][] matRes = new double[][]{{-3.85, 2.225, 1.125}, {1.15, -2.775, 1.125}, {2.3, 1.45, -4.75}};
        SparseContPhaseVar real = new SparseContPhaseVar(vecRes, matRes);
        SparseContClosureTest.assertTrue((String)"Waiting in Queue Distribution non equal (Matrix)", (real.getMatrix().add(-1.0, calc.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-4 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Waiting in Queue Distribution non equal (Vector)", (real.getVector().add(-1.0, calc.getVector()).norm(Vector.Norm.Infinity) < 1.0E-4 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix2).add(-1.0, this.var2.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector2).add(-1.0, this.var2.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testSumPH() {
        SparseContPhaseVar calc = (SparseContPhaseVar)this.var2.sumPH(this.varD);
        double[] vecRes = new double[]{0.0242, 0.1418, 0.0484, 0.2836, 0.0484, 0.2836};
        double[][] matRes = new double[][]{{-3.9387, 0.0312, 2.1226, 0.0624, 1.1226, 0.0624}, {0.0, -3.9387, 0.0, 2.1226, 0.0, 1.1226}, {1.0613, 0.0312, -2.8774, 0.0624, 1.1226, 0.0624}, {0.0, 1.0613, 0.0, -2.8774, 0.0, 1.1226}, {2.1226, 0.0624, 1.2452, 0.1249, -4.7548, 0.1249}, {0.0, 2.1226, 0.0, 1.2452, 0.0, -4.7548}};
        SparseContPhaseVar real = new SparseContPhaseVar(vecRes, matRes);
        SparseContClosureTest.assertTrue((String)"Waiting in Queue Distribution non equal (Matrix)", (real.getMatrix().add(-1.0, calc.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-4 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Waiting in Queue Distribution non equal (Vector)", (real.getVector().add(-1.0, calc.getVector()).norm(Vector.Norm.Infinity) < 1.0E-4 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Matrix changed", (new DenseMatrix(this.matrix2).add(-1.0, this.var2.getMatrix()).norm(Matrix.Norm.Maxvalue) < 1.0E-5 ? 1 : 0) != 0);
        SparseContClosureTest.assertTrue((String)"Vector changed", (new DenseVector(this.vector2).add(-1.0, this.var2.getVector()).norm(Vector.Norm.Infinity) < 1.0E-5 ? 1 : 0) != 0);
    }
}

