/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jphase.DenseContPhaseVar;
import jphase.PhaseVar;

public class PhaseVarSet
implements Serializable {
    private static final long serialVersionUID = -8599741746745927478L;
    private List<PhaseVar> vars = new ArrayList<PhaseVar>();
    private List<String> names = new ArrayList<String>();
    public String name = "Untitled";
    public String fileName = "";
    public boolean isDirty = false;

    public PhaseVarSet() {
    }

    public PhaseVarSet(String nam) {
        this.name = nam;
    }

    public PhaseVarSet(PhaseVar[] vars) {
        int i = 0;
        while (i < vars.length) {
            this.add(vars[i]);
            ++i;
        }
    }

    public PhaseVarSet(String nam, PhaseVar[] vars) {
        this(vars);
        this.name = nam;
    }

    public String newUniqueVarName(String proposedName) {
        if (this.indexOfName(proposedName) == -1) {
            return proposedName;
        }
        int k = 1;
        while (this.indexOfName(String.valueOf(proposedName) + k) != -1) {
            ++k;
        }
        return String.valueOf(proposedName) + k;
    }

    public void add(PhaseVar var) {
        this.names.add(this.newUniqueVarName(var.label()));
        this.vars.add(var);
        this.isDirty = true;
    }

    public PhaseVar varAt(int i) {
        return this.vars.get(i);
    }

    public int indexOfName(String s) {
        return this.names.indexOf(s);
    }

    public int numVars() {
        return this.vars.size();
    }

    public int remove(String varName) {
        int idx = this.indexOfName(varName);
        if (idx != -1) {
            this.vars.get(idx);
            this.isDirty = true;
        }
        return idx;
    }

    public void remove(PhaseVar var) {
        this.vars.remove(var);
        this.isDirty = true;
    }

    public double[] getMeans() {
        int tot = this.vars.size();
        double[] vec = new double[tot];
        int i = 0;
        while (i < tot) {
            vec[i] = this.varAt(i).expectedValue();
            ++i;
        }
        return vec;
    }

    public static PhaseVarSet open(String fileName) throws Exception {
        FileInputStream in = new FileInputStream(fileName);
        ObjectInputStream s = new ObjectInputStream(in);
        PhaseVarSet set = (PhaseVarSet)s.readObject();
        s.close();
        set.fileName = fileName;
        String name = new File(fileName).getName();
        if (name.endsWith(".sed")) {
            name = name.substring(0, name.length() - 4);
        }
        set.name = name;
        set.isDirty = false;
        return set;
    }

    public static PhaseVarSet openTxt(String fileName) throws Exception {
        PhaseVarSet set = new PhaseVarSet();
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        set.name = in.readLine();
        while (in.ready()) {
            DenseContPhaseVar var = new DenseContPhaseVar();
            set.add(var);
        }
        in.close();
        set.fileName = fileName;
        String name = new File(fileName).getName();
        if (name.endsWith(".sed")) {
            name = name.substring(0, name.length() - 4);
        }
        set.name = name;
        set.isDirty = false;
        return set;
    }

    public void save() throws IOException {
        if (this.fileName == "") {
            this.fileName = String.valueOf(this.name) + ".sed";
        }
        this.save(this.fileName);
    }

    public void save(String fileName) throws IOException {
        this.fileName = fileName;
        File archie = new File(fileName);
        String theName = archie.getName();
        int le = theName.length();
        this.name = theName.substring(0, le - 4);
        FileOutputStream out = new FileOutputStream(archie);
        ObjectOutputStream s = new ObjectOutputStream(out);
        s.writeObject(this);
        s.flush();
        this.isDirty = false;
    }

    public boolean saveTxt() throws IOException {
        if (this.fileName == "") {
            this.fileName = String.valueOf(this.name) + ".sed";
        }
        return this.saveTxt(this.fileName);
    }

    public boolean saveTxt(String fileName) throws IOException {
        try {
            this.fileName = fileName;
            String theName = new File(fileName).getName();
            int le = theName.length();
            this.name = theName.substring(0, le - 4);
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
            out.write(this.toString());
            out.close();
            this.isDirty = false;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        String stg = String.valueOf(this.name) + "\n";
        int n = this.vars.size();
        int i = 0;
        while (i < n) {
            stg = String.valueOf(stg) + this.varAt(i).toString();
            stg = String.valueOf(stg) + "\n";
            ++i;
        }
        return stg;
    }
}

