/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import Jama.Matrix;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import jphase.Utils;

public class MarkovMatrix
extends Matrix {
    private static final long serialVersionUID = 1969L;
    static double Epsilon = 1.0E-10;
    public static boolean useUniformization = true;
    private List<Matrix> powers;
    private int maxPower = 1;
    private MarkovMatrix normal = null;
    private double ldaMax = -1.0;
    MarkovMatrix aExpStep = null;

    public MarkovMatrix(double[][] mat) {
        super(mat);
    }

    public MarkovMatrix(Matrix mat) {
        super(mat.getArray());
    }

    public static MarkovMatrix readTxt(String stg) {
        StringTokenizer tkn = new StringTokenizer(stg, ":;", false);
        int m = Integer.valueOf(tkn.nextToken());
        int n = Integer.valueOf(tkn.nextToken());
        double[][] A = new double[m][n];
        int i = 0;
        int j = 0;
        while (tkn.hasMoreTokens()) {
            String rowStg = tkn.nextToken();
            StringTokenizer tkn2 = new StringTokenizer(rowStg, " ", false);
            j = 0;
            while (tkn2.hasMoreTokens()) {
                A[i][j] = Double.valueOf(tkn2.nextToken());
                ++j;
            }
            ++i;
        }
        return new MarkovMatrix(A);
    }

    static MarkovMatrix Ones(int m, int n) {
        return (MarkovMatrix)new Matrix(m, n, 1.0);
    }

    static MarkovMatrix Ones(int m) {
        return new MarkovMatrix(new Matrix(m, 1, 1.0));
    }

    public static MarkovMatrix Zeros(int rows, int cols) {
        return new MarkovMatrix(new Matrix(rows, cols));
    }

    public Matrix inverse() {
        return new MarkovMatrix(super.inverse());
    }

    public Matrix uminus() {
        return new MarkovMatrix(super.uminus());
    }

    public static Matrix identity(int n) {
        return new MarkovMatrix(Matrix.identity((int)n, (int)n));
    }

    public Matrix times(double s) {
        return new MarkovMatrix(super.times(s));
    }

    public int size() {
        return super.getColumnDimension();
    }

    public Matrix times(Matrix B) {
        return new MarkovMatrix(super.times(B));
    }

    public static MarkovMatrix toMarkovMatrix(Matrix A) {
        return new MarkovMatrix(A);
    }

    public Matrix solveTranspose(Matrix B) {
        return this.transpose().solve(B.transpose()).transpose();
    }

    public boolean isStochastic() {
        boolean result = true;
        int n = this.size();
        int i = 0;
        while (result && i < n) {
            double sum = 0.0;
            int j = 0;
            while (result && j < n) {
                double val = this.get(i, j);
                result &= val >= 0.0;
                sum += this.get(i, j);
                ++j;
            }
            result &= Math.abs(sum - 1.0) < Epsilon;
            ++i;
        }
        return result;
    }

    public MarkovMatrix power(int k) {
        int n = this.getRowDimension();
        Matrix result = Matrix.identity((int)n, (int)n);
        int i = 1;
        while (i <= k) {
            result = result.times((Matrix)this);
            ++i;
        }
        return new MarkovMatrix(result);
    }

    public MarkovMatrix timesOne() {
        int m = this.getRowDimension();
        int n = this.getColumnDimension();
        double sum = 0.0;
        double[][] result = new double[m][1];
        int i = 0;
        while (i < m) {
            sum = 0.0;
            int j = 0;
            while (j < n) {
                sum += this.get(i, j);
                ++j;
            }
            result[i][0] = sum;
            ++i;
        }
        return new MarkovMatrix(result);
    }

    public double scalar() {
        if (this.size() == 1) {
            return super.get(0, 0);
        }
        throw new NumberFormatException("Max iterations reached computing exp()");
    }

    public MarkovMatrix compExp() {
        int n = this.getRowDimension();
        int m = this.getColumnDimension();
        double[][] A = this.getArrayCopy();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                A[i][j] = Math.exp(A[i][j]);
                ++j;
            }
            ++i;
        }
        return new MarkovMatrix(A);
    }

    public MarkovMatrix compLog() {
        int n = this.getRowDimension();
        int m = this.getColumnDimension();
        double[][] A = this.getArrayCopy();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                A[i][j] = Math.log(Math.abs(A[i][j]));
                ++j;
            }
            ++i;
        }
        return new MarkovMatrix(A);
    }

    public MarkovMatrix plus(double x) {
        int n = this.getRowDimension();
        int m = this.getColumnDimension();
        double[][] A = this.getArrayCopy();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                A[i][j] = A[i][j] + x;
                ++j;
            }
            ++i;
        }
        return new MarkovMatrix(A);
    }

    private MarkovMatrix compTimesExp(double x) {
        int n = this.getRowDimension();
        int m = this.getColumnDimension();
        double[][] A = this.getArrayCopy();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                if (A[i][j] != 0.0) {
                    double sign = A[i][j] > 0.0 ? 1.0 : -1.0;
                    A[i][j] = sign * Math.exp(Math.log(Math.abs(A[i][j])) + x);
                }
                ++j;
            }
            ++i;
        }
        return new MarkovMatrix(A);
    }

    public Matrix pow(int k) {
        if (this.powers == null) {
            this.powers = new ArrayList<Matrix>(100);
            this.powers.add(MarkovMatrix.identity(this.getRowDimension()));
            this.powers.add(this);
        }
        if (k <= this.maxPower) {
            return this.powers.get(k);
        }
        Matrix newPower = null;
        int i = this.maxPower + 1;
        while (i <= k) {
            newPower = this.powers.get(i - 1);
            newPower = newPower.times((Matrix)this);
            this.powers.add(newPower);
            ++i;
        }
        this.maxPower = k;
        return newPower;
    }

    MarkovMatrix getNormalized() {
        if (this.normal == null) {
            int n = this.size();
            this.computeLdaMax();
            this.normal = new MarkovMatrix(MarkovMatrix.identity((int)n, (int)n).plus(this.times(1.0 / this.ldaMax)));
        }
        return this.normal;
    }

    private void computeLdaMax() {
        int n = this.size();
        int i = 0;
        while (i < n) {
            this.ldaMax = Math.max(this.ldaMax, -this.get(i, i));
            ++i;
        }
    }

    public MarkovMatrix expTimesOnes(double x) {
        int n = this.getColumnDimension();
        return this.exp(x, MarkovMatrix.identity(n), MarkovMatrix.Ones(n));
    }

    public MarkovMatrix expTimesOnes(double x, Matrix leftMatrix) {
        int n = this.getColumnDimension();
        return this.exp(x, leftMatrix, MarkovMatrix.Ones(n));
    }

    public MarkovMatrix[] expTimesOnes(int N, double delta, Matrix leftMatrix) {
        int n = this.getColumnDimension();
        return this.exp(N, delta, leftMatrix, MarkovMatrix.Ones(n));
    }

    public MarkovMatrix exp(double x, Matrix leftMat, Matrix rightMat) {
        MarkovMatrix[] result = this.exp(2, x, leftMat, rightMat);
        return result[1];
    }

    public MarkovMatrix exp(double x) {
        int n = this.getRowDimension();
        MarkovMatrix[] result = this.exp(2, x, MarkovMatrix.identity(n), MarkovMatrix.identity(n));
        return result[1];
    }

    public MarkovMatrix[] exp(int n, double delta, Matrix leftMat, Matrix rightMat) {
        if (useUniformization) {
            return this.expUnif(n, delta, leftMat, rightMat);
        }
        return this.expRunge(n, delta, leftMat, rightMat);
    }

    public MarkovMatrix[] expRunge(int n, double delta, Matrix leftMat, Matrix rightMat) {
        MarkovMatrix[] result = new MarkovMatrix[n];
        Matrix y = leftMat;
        double bigStep = delta;
        this.computeLdaMax();
        double k = Math.ceil(this.ldaMax * bigStep);
        double step = bigStep / k;
        double xVal = 0.0;
        int i = 0;
        while (i < n) {
            result[i] = new MarkovMatrix(y.times(rightMat));
            int j = 0;
            while ((double)j < k) {
                y = this.runge4(y, step);
                xVal += step;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public MarkovMatrix[] expUnif(double x, Matrix leftMat, Matrix rightMat) {
        return this.expUnif(new double[]{x}, leftMat, rightMat, Integer.MAX_VALUE);
    }

    public MarkovMatrix[] expUnif(int n, double delta, Matrix leftMat, Matrix rightMat) {
        return this.expUnif(n, delta, leftMat, rightMat, Integer.MAX_VALUE);
    }

    public MarkovMatrix[] expUnif(double[] times, Matrix leftMat, Matrix rightMat) {
        return this.expUnif(times, leftMat, rightMat, Integer.MAX_VALUE);
    }

    public MarkovMatrix[] expUnif(int n, double delta, Matrix leftMat, Matrix rightMat, int truncate) {
        double[] times = new double[n];
        int i = 0;
        while (i < n) {
            times[i] = delta * (double)i;
            ++i;
        }
        return this.expUnif(times, leftMat, rightMat, truncate);
    }

    public MarkovMatrix[] expUnif(double[] times, Matrix leftMat, Matrix rightMat, int truncate) {
        Vector<Matrix> Avec = new Vector<Matrix>();
        double dif = Double.MAX_VALUE;
        int maxK = Integer.MAX_VALUE;
        boolean isStoch = false;
        Matrix M = null;
        MarkovMatrix matP = this.getNormalized();
        int n = times.length;
        int MaxIterations = Math.max(200, (int)(3.0 * this.ldaMax * times[n - 1]));
        if (!matP.isStochastic()) {
            Matrix sol = MarkovMatrix.identity(this.size()).minus((Matrix)matP).solve(rightMat);
            M = leftMat.times(sol);
        } else {
            isStoch = true;
            maxK = MaxIterations - 1;
        }
        Matrix Ak = leftMat.times(rightMat);
        Avec.addElement(Ak);
        Matrix sumA = Ak.copy();
        int k = 0;
        Matrix V = matP.times(rightMat);
        do {
            ++k;
            Ak = leftMat.times(V);
            Avec.addElement(Ak);
            sumA = sumA.plus(Ak);
            V = matP.times(V);
            if (isStoch) continue;
            dif = Math.abs(sumA.minus(M).normInf());
        } while (k < maxK && dif > Epsilon && k < MaxIterations && k < truncate);
        if (k == MaxIterations && truncate == Integer.MAX_VALUE) {
            throw new RuntimeException("Max iterations reached (" + MaxIterations + ")");
        }
        if (!isStoch) {
            maxK = k;
        }
        Matrix[] A = new Matrix[maxK + 1];
        k = 0;
        while (k <= maxK) {
            A[k] = (Matrix)Avec.elementAt(k);
            ++k;
        }
        Matrix[] result = new Matrix[n];
        int i = 0;
        while (i < n) {
            double ldaX = this.ldaMax * times[i];
            double pk = Math.exp(-ldaX);
            if (pk < Double.MIN_VALUE) {
                result[i] = this.resultFromMedian(A, ldaX);
            } else {
                double sumPk = pk;
                result[i] = A[0].times(pk);
                k = 1;
                while (k <= maxK) {
                    result[i] = result[i].plus(A[k].times(pk));
                    if (1.0 - (sumPk += (pk *= ldaX / (double)k)) < Epsilon) break;
                    ++k;
                }
            }
            ++i;
        }
        MarkovMatrix[] GrmResult = new MarkovMatrix[n];
        int i2 = 0;
        while (i2 < n) {
            GrmResult[i2] = new MarkovMatrix(result[i2]);
            ++i2;
        }
        return GrmResult;
    }

    private Matrix resultFromMedian(Matrix[] A, double ldaX) {
        double p_plus;
        if (ldaX == 0.0) {
            return A[0];
        }
        int median = (int)Math.floor(ldaX);
        double p_minus = p_plus = Math.exp(-ldaX + (double)median * Math.log(ldaX) - Utils.lnFactorial(median));
        double sumPk = p_plus;
        int m = A[0].getColumnDimension();
        MarkovMatrix result = median < A.length ? A[median].times(p_plus) : MarkovMatrix.Zeros(m, m);
        int k_minus = median;
        int k_plus = median;
        int maxK = Math.max(median, A.length - median + 1);
        int k = 1;
        while (k < maxK && sumPk < 0.999) {
            p_minus = p_minus * (double)(--k_minus + 1) / ldaX;
            sumPk += (p_plus *= ldaX / (double)(++k_plus)) + p_minus;
            if (k_plus < A.length) {
                result = result.plus(A[k_plus].times(p_plus));
            }
            if (k_minus < A.length && k_minus >= 0) {
                result = result.plus(A[k_minus].times(p_minus));
            }
            ++k;
        }
        return result;
    }

    public Matrix kroneckerSum(Matrix B) {
        int rows1 = this.getRowDimension();
        int rows2 = B.getRowDimension();
        return this.kronecker(MarkovMatrix.identity(rows2)).plus(MarkovMatrix.kronecker(MarkovMatrix.identity(rows1), B));
    }

    public static Matrix kroneckerSum(Matrix A, Matrix B) {
        return new MarkovMatrix(A).kroneckerSum(B);
    }

    public static Matrix kronecker(Matrix A, Matrix B) {
        int r1 = A.getRowDimension();
        int c1 = A.getColumnDimension();
        int r2 = B.getRowDimension();
        int c2 = B.getColumnDimension();
        Matrix result = new Matrix(r1 * r2, c1 * c2);
        int i = 0;
        while (i < r1) {
            int j = 0;
            while (j < c1) {
                result.setMatrix(i * r2, i * r2 + r2 - 1, j * c2, j * c2 + c2 - 1, B.times(A.get(i, j)));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public Matrix kronecker(Matrix B) {
        return MarkovMatrix.kronecker(this, B);
    }

    public static Matrix concatCols(Matrix A, Matrix B) {
        int r1 = A.getRowDimension();
        int c1 = A.getColumnDimension();
        int r2 = B.getRowDimension();
        int c2 = B.getColumnDimension();
        if (r1 != r2) {
            throw new IndexOutOfBoundsException("Matrices cannot be concatenated: (" + r1 + "," + c1 + ")|(" + r2 + "," + c2 + ")");
        }
        Matrix C = new Matrix(r1, c1 + c2);
        C.setMatrix(0, r1 - 1, 0, c1 - 1, A);
        C.setMatrix(0, r1 - 1, c1, c1 + c2 - 1, B);
        return C;
    }

    public static Matrix concatRows(Matrix A, Matrix B) {
        int r1 = A.getRowDimension();
        int c1 = A.getColumnDimension();
        int r2 = B.getRowDimension();
        int c2 = B.getColumnDimension();
        if (c1 != c2) {
            throw new IndexOutOfBoundsException("Matrices cannot be concatenated: (" + r1 + "," + c1 + ")--(" + r2 + "," + c2 + ")");
        }
        Matrix C = new Matrix(r1 + r2, c1);
        C.setMatrix(0, r1 - 1, 0, c1 - 1, A);
        C.setMatrix(r1, r1 + r2 - 1, 0, c1 - 1, B);
        return C;
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pwt = new PrintWriter(os);
        this.print(pwt, 5, 2);
        try {
            os.flush();
            pwt.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return os.toString();
    }

    public String toTxt() {
        String stg = "";
        int m = this.getRowDimension();
        int n = this.getColumnDimension();
        double[][] A = this.getArray();
        stg = String.valueOf(stg) + m + ":" + n + ":";
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                stg = String.valueOf(stg) + A[i][j] + " ";
                ++j;
            }
            stg = String.valueOf(stg) + ";";
            ++i;
        }
        return stg;
    }

    public String toStringRTF() {
        int r = this.getRowDimension();
        int c = this.getColumnDimension();
        String stg = "";
        int i = 0;
        while (i < r) {
            stg = String.valueOf(stg) + new MarkovMatrix(this.getMatrix(i, i, 0, c - 1)).toString() + "\\par";
            ++i;
        }
        return stg;
    }

    public MarkovMatrix oldExp(double x, Matrix rightMat) {
        double logSumPk;
        int maxK = 30000;
        double lOmE = Math.log(1.0 - Epsilon);
        MarkovMatrix matP = this.getNormalized();
        double ldaX = this.ldaMax * x;
        double pk = Math.exp(-ldaX);
        if (pk < Double.MIN_VALUE) {
            pk = 1.4E-45f;
        }
        double logEndLevel = Math.log(pk) + lOmE + ldaX;
        double sumPk = pk;
        Matrix matCk = MarkovMatrix.identity(this.getColumnDimension());
        Matrix result = matCk.copy().times(pk);
        int k = 1;
        double alarmLevel = 3.402823466385289E23;
        do {
            logSumPk = Math.log(sumPk += (pk *= ldaX / (double)k));
            if (sumPk > alarmLevel) {
                pk /= sumPk;
                result = result.times(1.0 / sumPk);
                logEndLevel -= logSumPk;
                sumPk = 1.0;
            }
            matCk = matP.pow(k);
            result = result.plus(matCk.times(pk));
        } while (logSumPk < logEndLevel && ++k < maxK);
        if (k == maxK) {
            throw new NumberFormatException("Max iterations reached");
        }
        return new MarkovMatrix(result.times(1.0 / sumPk).times(rightMat));
    }

    private Matrix runge4(Matrix y, double step) {
        Matrix k1 = y.times((Matrix)this).times(step);
        Matrix t1 = y.plus(k1.times(0.5));
        Matrix k2 = t1.times((Matrix)this).times(step);
        Matrix t2 = y.plus(k2.times(0.5));
        Matrix k3 = t2.times((Matrix)this).times(step);
        Matrix t3 = y.plus(k3);
        Matrix k4 = t3.times((Matrix)this).times(step);
        k2 = k2.times(2.0);
        k1 = k1.times(2.0);
        y = y.plus(k1.plus(k2).plus(k3).plus(k4).times(0.16666666666666666));
        return y;
    }

    private Matrix runge4B(double x, Matrix y, double step) {
        if (this.aExpStep == null) {
            int n = this.size();
            MarkovMatrix[] y2 = this.expUnif(2, step, MarkovMatrix.identity(n), MarkovMatrix.identity(n), 4);
            this.aExpStep = y2[1];
        }
        return y.times((Matrix)this.aExpStep);
    }
}

