/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import jphase.AbstractContPhaseVar;
import jphase.ContPhaseVar;
import jphase.PhaseVar;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public class HyperErlangVar
extends AbstractContPhaseVar
implements PhaseVar {
    private int N;
    private int M;
    private int[] r;
    private double[] alphas;
    private double[] lambdas;

    public HyperErlangVar() {
        this.N = 1;
        this.M = 1;
        this.r = new int[this.M];
        this.r[0] = 1;
        this.alphas = new double[this.M];
        this.alphas[0] = 1.0;
        this.lambdas = new double[this.M];
        this.lambdas[0] = 1.0;
    }

    public HyperErlangVar(int n) {
        this.N = n;
    }

    public HyperErlangVar(int N, int M, int[] r, double[] alphas, double[] lambdas, boolean deep) {
        if (M == r.length && M == alphas.length && M == lambdas.length) {
            this.N = N;
            this.M = M;
            if (deep) {
                this.r = new int[M];
                this.alphas = new double[M];
                this.lambdas = new double[M];
                System.arraycopy(r, 0, this.r, 0, M);
                System.arraycopy(alphas, 0, this.alphas, 0, M);
                System.arraycopy(lambdas, 0, this.lambdas, 0, M);
            } else {
                this.r = r;
                this.alphas = alphas;
                this.lambdas = lambdas;
            }
        }
    }

    public HyperErlangVar(int[] r, double[] alphas, double[] lambdas, boolean deep) {
        if (r.length == alphas.length && alphas.length == lambdas.length) {
            this.M = r.length;
            int i = 0;
            while (i < this.M) {
                this.N += r[i];
                ++i;
            }
            if (deep) {
                this.r = new int[this.M];
                this.alphas = new double[this.M];
                this.lambdas = new double[this.M];
                System.arraycopy(r, 0, this.r, 0, this.M);
                System.arraycopy(alphas, 0, this.alphas, 0, this.M);
                System.arraycopy(lambdas, 0, this.lambdas, 0, this.M);
            } else {
                this.r = r;
                this.alphas = alphas;
                this.lambdas = lambdas;
            }
        }
    }

    public int getN() {
        return this.N;
    }

    public void setN(int N) {
        this.N = N;
    }

    public int getM() {
        return this.M;
    }

    public void setM(int M) {
        this.M = M;
    }

    public int[] getR() {
        return this.r;
    }

    public void setR(int[] r) {
        this.r = r;
    }

    public double[] getAlphas() {
        return this.alphas;
    }

    public void setAlphas(double[] alphas) {
        this.alphas = alphas;
    }

    public double[] getLambdas() {
        return this.lambdas;
    }

    public void setLambdas(double[] lambdas) {
        this.lambdas = lambdas;
    }

    @Override
    public Matrix getMatrix() {
        return new DenseMatrix(this.getDMatrix());
    }

    public double[][] getDMatrix() {
        int N = this.getN();
        int l = 0;
        double[][] matriz = new double[N][N];
        int i = 0;
        while (i < this.getM()) {
            int j = 0;
            while (j < this.getR()[i]) {
                matriz[l][l] = -this.getLambdas()[i];
                if (l < N - 1 && j < this.getR()[i] - 1) {
                    matriz[l][l + 1] = this.getLambdas()[i];
                }
                ++l;
                ++j;
            }
            ++i;
        }
        return matriz;
    }

    @Override
    public void setMatrix(Matrix A) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Vector getVector() {
        return new DenseVector(this.getDVector());
    }

    public double[] getDVector() {
        int N = this.getN();
        int l = 0;
        double[] vector = new double[N];
        int i = 0;
        while (i < this.getM()) {
            int j = 0;
            while (j < this.getR()[i]) {
                vector[l] = j == 0 ? this.getAlphas()[i] : 0.0;
                ++l;
                ++j;
            }
            ++i;
        }
        return vector;
    }

    @Override
    public void setVector(Vector alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContPhaseVar copy() {
        return new HyperErlangVar(this.N, this.M, this.r, this.alphas, this.lambdas, true);
    }

    @Override
    public ContPhaseVar newVar(int n) {
        return new HyperErlangVar(n);
    }

    @Override
    public int getNumPhases() {
        return this.getN();
    }

    @Override
    public double expectedValue() {
        double m = 0.0;
        int i = 0;
        while (i < this.getM()) {
            m += this.getAlphas()[i] * (double)this.getR()[i] / this.getLambdas()[i];
            ++i;
        }
        return m;
    }

    @Override
    public double moment(int k) {
        double sum = 0.0;
        int i = 0;
        while (i < this.M) {
            double temp1 = this.alphas[i] / Math.pow(this.lambdas[i], k);
            int j = 0;
            while (j <= k - 1) {
                temp1 *= (double)(this.r[i] + j);
                ++j;
            }
            sum += temp1;
            ++i;
        }
        return sum;
    }
}

