/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import jphase.AbstractContPhaseVar;
import jphase.DenseContPhaseVar;
import jphase.GUI.PhaseVarInfo;
import jphase.PhaseVar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class TreeManagerPanel
extends JPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    JSplitPane splitPane;
    private JTabbedPane varPane;
    private JScrollPane varScroll;
    private JComponent paramPane;
    private ChartPanel pdfPane;
    private ChartPanel cdfPane;
    private JPanel statPane;
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private ArrayList<PhaseVarInfo> variables;
    private static boolean DEBUG = false;
    private int width = 500;
    private int height = 300;
    private int widthDiv = 200;

    public TreeManagerPanel() {
        super(new GridLayout(1, 0));
        this.rootNode = new DefaultMutableTreeNode("Phase Var Sets");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.addTreeModelListener(new MyTreeModelListener());
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.createNodes();
        ImageIcon leafIcon = TreeManagerPanel.createImageIcon("/jphase/GUI/images/var.jpg");
        ImageIcon closedIcon = TreeManagerPanel.createImageIcon("/jphase/GUI/images/closedSet.gif");
        ImageIcon openIcon = TreeManagerPanel.createImageIcon("/jphase/GUI/images/openSet.gif");
        if (leafIcon != null) {
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            renderer.setLeafIcon(leafIcon);
            renderer.setOpenIcon(openIcon);
            renderer.setClosedIcon(closedIcon);
            this.tree.setCellRenderer(renderer);
        } else {
            System.err.println("Leaf icon missing; using default.");
        }
        this.tree.addTreeSelectionListener(this);
        JScrollPane treeView = new JScrollPane(this.tree);
        this.varPane = new JTabbedPane();
        this.varScroll = new JScrollPane(this.varPane);
        this.splitPane = new JSplitPane(1);
        this.splitPane.setTopComponent(treeView);
        this.splitPane.setBottomComponent(this.varScroll);
        Dimension minimumSize = new Dimension(100, 50);
        this.varScroll.setMinimumSize(minimumSize);
        treeView.setMinimumSize(minimumSize);
        this.splitPane.setDividerLocation(this.widthDiv);
        this.splitPane.setPreferredSize(new Dimension(this.width, this.height));
        this.add(this.splitPane);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            System.out.println("lastSelectedPathComponent es null");
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {
            PhaseVarInfo info = (PhaseVarInfo)nodeInfo;
            this.displayVar(info);
        }
        if (DEBUG) {
            System.out.println(nodeInfo.toString());
        }
    }

    public void displayVar(PhaseVarInfo info) {
        if (info != null) {
            if (this.paramPane != null) {
                this.paramPane.removeAll();
            }
            if (this.pdfPane != null) {
                this.pdfPane.removeAll();
            }
            if (this.cdfPane != null) {
                this.cdfPane.removeAll();
            }
            if (this.statPane != null) {
                this.statPane.removeAll();
            }
            if (this.varPane != null) {
                this.varPane.removeAll();
            }
            JTextArea param = new JTextArea(String.valueOf(info.toString()) + "\n" + info.var.description());
            param.setEditable(false);
            param.setPreferredSize(new Dimension(Math.max(100 + info.var.getVectorArray().length * 95, this.height), this.height));
            ImageIcon icon = TreeManagerPanel.createImageIcon("/jphase/GUI/images/var.jpg");
            param.setBorder(new LineBorder(Color.BLACK));
            this.paramPane = new JPanel();
            this.paramPane.setPreferredSize(new Dimension(this.width, this.height));
            this.paramPane.add((Component)param, "Center");
            this.varPane.addTab("Parameters", icon, this.paramPane, "Distribution Parameters");
            XYSeries dataPDF = new XYSeries((Comparable)((Object)"PDF"), true, false);
            double mean = info.var.expectedValue();
            double sigma = info.var.stdDeviation();
            double xMax = mean + Math.max(3.0 * sigma, 0.5 * mean);
            double cv = info.var.CV();
            double numPoints = 20 + (!Double.isNaN(cv) ? (int)(5.0 * cv) : 0);
            numPoints = (int)Math.max(400.0, numPoints);
            double dx = xMax / numPoints;
            double x = 0.0;
            if (info.var.getNumPhases() == 1) {
                x = dx;
            }
            int i = 0;
            while ((double)i < numPoints) {
                dataPDF.add(x, ((AbstractContPhaseVar)info.var).pdf(x));
                x += dx;
                ++i;
            }
            DefaultTableXYDataset datasetPDF = new DefaultTableXYDataset();
            datasetPDF.addSeries(dataPDF);
            JFreeChart chartPDF = ChartFactory.createXYLineChart((String)"PDF", (String)"x", (String)"f(x)", (XYDataset)datasetPDF, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            this.pdfPane = new ChartPanel(chartPDF);
            this.pdfPane.setPreferredSize(new Dimension(this.width, this.height));
            this.varPane.addTab("PDF", icon, (Component)this.pdfPane, "Probability Density Function");
            XYSeries dataCDF = new XYSeries((Comparable)((Object)"CDF"), true, false);
            x = 0.0;
            int i2 = 0;
            while ((double)i2 < numPoints) {
                dataCDF.add(x, info.var.cdf(x));
                x += dx;
                ++i2;
            }
            DefaultTableXYDataset datasetCDF = new DefaultTableXYDataset();
            datasetCDF.addSeries(dataCDF);
            JFreeChart chartCDF = ChartFactory.createXYLineChart((String)"CDF", (String)"x", (String)"F(x)", (XYDataset)datasetCDF, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
            this.cdfPane = new ChartPanel(chartCDF);
            this.cdfPane.setPreferredSize(new Dimension(this.width, this.height));
            this.varPane.addTab("CDF", icon, (Component)this.cdfPane, "Cumulative Probability Function");
            String stats = "Expected Value: " + String.format("%6.4f", info.var.expectedValue());
            stats = String.valueOf(stats) + "\nVariance: " + String.format("%6.4f", info.var.variance());
            stats = String.valueOf(stats) + "\nNumber of Phases: " + info.var.getNumPhases();
            stats = String.valueOf(stats) + "\n--------------------------------------------";
            stats = String.valueOf(stats) + "\nMoment 1: " + String.format("%6.4f", info.var.moment(1));
            stats = String.valueOf(stats) + "\nMoment 2: " + String.format("%6.4f", info.var.moment(2));
            stats = String.valueOf(stats) + "\nMoment 3: " + String.format("%6.4f", info.var.moment(3));
            stats = String.valueOf(stats) + "\nMoment 4: " + String.format("%6.4f", info.var.moment(4));
            param = new JTextArea(stats);
            this.statPane = new JPanel();
            this.statPane.setPreferredSize(new Dimension(this.width, this.height));
            this.statPane.add((Component)param, "Center");
            this.varPane.addTab("Statistics", icon, this.statPane, "Distribution Statistics");
        } else {
            this.varPane.setBackground(Color.WHITE);
            if (DEBUG) {
                System.out.println("Attempted to display a null URL.");
            }
        }
    }

    private void createNodes() {
        PhaseVarInfo var = null;
        DefaultMutableTreeNode category1 = this.addObject(null, "Set 1");
        this.variables = new ArrayList();
        var = new PhaseVarInfo("Expo 5", DenseContPhaseVar.expo(5.0));
        this.addObject(category1, var);
        this.variables.add(var);
        var = new PhaseVarInfo("Erlang (5, 2)", DenseContPhaseVar.Erlang(5.0, 2));
        this.addObject(category1, var);
        this.variables.add(var);
        var = new PhaseVarInfo("Expo 15", DenseContPhaseVar.expo(15.0));
        this.addObject(category1, var);
        this.variables.add(var);
        var = new PhaseVarInfo("Erlang (15, 3)", DenseContPhaseVar.Erlang(15.0, 3));
        this.addObject(category1, var);
        this.variables.add(var);
    }

    public void addSet(String name) {
        PhaseVarInfo info = null;
        DefaultMutableTreeNode cat = this.addObject(null, name);
        info = new PhaseVarInfo("New Var", DenseContPhaseVar.expo(2.0));
        this.addObject(cat, info);
    }

    public boolean canAddVar() {
        TreePath parentPath = this.tree.getSelectionPath();
        if (parentPath == null || parentPath.getLastPathComponent() == this.rootNode) {
            this.toolkit.beep();
            return false;
        }
        return true;
    }

    public void addVar(String name, PhaseVar var) {
        PhaseVarInfo child = new PhaseVarInfo(name, var);
        DefaultMutableTreeNode parentNode = null;
        TreePath parentPath = this.tree.getSelectionPath();
        parentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        if (parentNode.getParent() != this.rootNode) {
            parentNode = (DefaultMutableTreeNode)parentNode.getParent();
        }
        this.addObject(parentNode, child, true);
        this.variables.add(child);
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode currentNode;
        MutableTreeNode parent;
        TreePath currentSelection = this.tree.getSelectionPath();
        if (currentSelection != null && (parent = (MutableTreeNode)(currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(currentNode);
            return;
        }
        this.toolkit.beep();
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child) {
        return this.addObject(parent, child, false);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = TreeManagerPanel.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public ArrayList<PhaseVarInfo> getVariables() {
        return this.variables;
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
            try {
                int index = e.getChildIndices()[0];
                node = (DefaultMutableTreeNode)node.getChildAt(index);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            System.out.println("The user has finished editing the node.");
            System.out.println("New value: " + node.getUserObject());
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }
}

