/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jphase.GUI.DistributionDialog;

class ParametersDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public final String ACEPTAR = "Acept";
    public final String CANCELAR = "Cancel";
    public JButton aceptarB;
    public JButton cancelarB;
    public ArrayList<String> nombre;
    public ArrayList<JLabel> labels;
    public ArrayList<JTextField> textos;
    private DistributionDialog dialogo;

    public ParametersDialog(ArrayList<String> parametros, DistributionDialog dialogoX) {
        this.dialogo = dialogoX;
        this.setSize(200, parametros.size() * 30 + 50);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.nombre = parametros;
        JPanel panUp = new JPanel();
        panUp.setLayout(new GridLayout(parametros.size(), 2));
        this.labels = new ArrayList();
        this.textos = new ArrayList();
        for (String param : this.nombre) {
            JLabel label = new JLabel(String.valueOf(param) + ": ");
            this.labels.add(label);
            panUp.add(label);
            JTextField texto = new JTextField();
            this.textos.add(texto);
            panUp.add(texto);
        }
        this.aceptarB = new JButton("Acept");
        this.aceptarB.setActionCommand("Acept");
        this.aceptarB.addActionListener(this);
        this.cancelarB = new JButton("Cancel");
        this.cancelarB.setActionCommand("Cancel");
        this.cancelarB.addActionListener(this);
        JPanel panDo = new JPanel();
        panDo.setLayout(new BorderLayout());
        panDo.add((Component)this.cancelarB, "West");
        panDo.add((Component)this.aceptarB, "East");
        this.add((Component)panUp, "North");
        this.add((Component)panDo, "South");
        this.setLocationRelativeTo(null);
        this.setTitle("Parameters");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String evento = e.getActionCommand();
        if (evento.equals("Acept")) {
            ArrayList<Double> valores = new ArrayList<Double>();
            boolean number = true;
            for (JTextField texto : this.textos) {
                try {
                    double valor = Double.parseDouble(texto.getText());
                    valores.add(valor);
                }
                catch (NumberFormatException e1) {
                    number = false;
                    break;
                }
            }
            if (number) {
                this.dialogo.establecerParametros(valores);
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this, "There are problems with some parameters", "Error", 0);
            }
        } else if (evento.equals("Cancel")) {
            this.dialogo.reactivar();
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        this.dialogo.reactivar();
        super.dispose();
    }
}

