/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jmarkov.jqbd.solvers.CLPAlgorithm;
import jmarkov.jqbd.solvers.ModBoundSolverFromMatrix;
import jmarkov.jqbd.solvers.MtjLogRedSolverFromMatrix;
import jmarkov.jqbd.solvers.QBDPhaseSolver;
import jphase.GUI.InputFrame;
import jphase.GUI.MainFrame;
import jphase.GUI.PhaseVarInfo;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;

public class NewQueueDialog
extends JDialog
implements ItemListener,
ActionListener {
    public final String ACEPT = "Generate";
    public final String CANCEL = "Cancel";
    public JButton aceptB;
    public JButton cancelB;
    public ArrayList<PhaseVarInfo> variables;
    public JComboBox arrivals;
    public JComboBox services;
    public ButtonGroup algorith;
    public JRadioButton Ualg;
    public JRadioButton LR;
    public JRadioButton ModBon;

    public NewQueueDialog(MainFrame window) {
        this.setTitle("JPhase - Construction of a PH/PH/1 model");
        this.algorith = new ButtonGroup();
        this.Ualg = new JRadioButton("Linear Progresion");
        this.algorith.add(this.Ualg);
        this.LR = new JRadioButton("Logarithmic Reduction");
        this.algorith.add(this.LR);
        this.ModBon = new JRadioButton("Modified Boundary");
        this.algorith.add(this.ModBon);
        this.LR.setSelected(true);
        this.aceptB = new JButton("Generate");
        this.aceptB.setActionCommand("Generate");
        this.aceptB.addActionListener(this);
        this.cancelB = new JButton("Cancel");
        this.cancelB.setActionCommand("Cancel");
        this.cancelB.addActionListener(this);
        this.setLayout(new BorderLayout());
        JPanel center = new JPanel();
        JPanel ncenter = new JPanel();
        JPanel algo = new JPanel();
        JPanel buttons = new JPanel();
        JPanel left = new JPanel();
        JPanel right = new JPanel();
        this.variables = window.getVariables();
        this.arrivals = new JComboBox<Object>(this.getNames(this.variables).toArray());
        this.arrivals.setSelectedIndex(0);
        this.arrivals.addItemListener(this);
        this.add(this.arrivals);
        this.services = new JComboBox<Object>(this.getNames(this.variables).toArray());
        this.services.setSelectedIndex(0);
        this.services.addItemListener(this);
        JLabel label1 = new JLabel("Please, select the Phase-Type distributions");
        JLabel label2 = new JLabel("that correspond to the distributions of");
        JLabel label3 = new JLabel("arrival and service times for a PH/PH/1/GD/\u00e2\u02c6\u017e/\u00e2\u02c6\u017e model");
        label1.setHorizontalAlignment(0);
        label2.setHorizontalAlignment(0);
        label3.setHorizontalAlignment(0);
        JLabel arrival = new JLabel("Arrivals");
        JLabel service = new JLabel("Services");
        left.add(arrival);
        left.add(this.arrivals);
        right.add(service);
        right.add(this.services);
        center.setLayout(new BorderLayout());
        center.add((Component)left, "North");
        center.add((Component)right, "South");
        algo.setLayout(new GridLayout(3, 1));
        algo.add(this.LR);
        algo.add(this.ModBon);
        algo.add(this.Ualg);
        ncenter.setLayout(new BorderLayout());
        ncenter.add((Component)center, "West");
        ncenter.add((Component)algo, "East");
        JPanel labels = new JPanel();
        labels.setLayout(new GridLayout(3, 1));
        labels.add(label1);
        labels.add(label2);
        labels.add(label3);
        this.add((Component)labels, "North");
        this.add((Component)ncenter, "Center");
        buttons.add(this.cancelB);
        buttons.add(this.aceptB);
        this.add((Component)buttons, "South");
        this.setSize(400, 200);
        this.setResizable(true);
        this.setLocationRelativeTo(null);
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String message = arg0.getActionCommand();
        if (message.equals("Generate")) {
            long ctime = System.currentTimeMillis();
            int arri = this.arrivals.getSelectedIndex();
            int serv = this.services.getSelectedIndex();
            QBDPhaseSolver test = null;
            test = this.Ualg.isSelected() ? new CLPAlgorithm(this.variables.get((int)arri).var, this.variables.get((int)serv).var) : (this.ModBon.isSelected() ? new ModBoundSolverFromMatrix(this.variables.get((int)arri).var, this.variables.get((int)serv).var) : new MtjLogRedSolverFromMatrix(this.variables.get((int)arri).var, this.variables.get((int)serv).var));
            if (test.unstableSystem()) {
                JOptionPane.showMessageDialog(this, "Unstable system", "Performance Measures", 0);
            } else {
                double[][] R = test.getRmatrix();
                test.printMatrices();
                String resp = test.performanceMeasures(R);
                ctime = System.currentTimeMillis() - ctime;
                resp = String.valueOf(resp) + "\nTime duration: " + ctime + " milisecond";
                resp = String.valueOf(resp) + (ctime != 1L ? "s" : "");
                JOptionPane.showMessageDialog(this, resp, "Performance Measures", 1);
                InputFrame probFrame = new InputFrame("Steady State", "Number of states");
                probFrame.setVisible(true);
                probFrame.setFocusable(true);
                if (probFrame.res) {
                    try {
                        int n = Integer.parseInt(probFrame.getValue());
                        ArrayList<Double> pis = test.getLevelSteadyStateProbs();
                        ArrayList<DenseMatrix> pisP = test.getSteadyStateProbsPerLevel();
                        String ans = "";
                        int i = 0;
                        while (i < n && i < pis.size()) {
                            ans = String.valueOf(ans) + "Pi(" + i + ")=" + String.format("%6.4f", pis.get(i)) + "\t{";
                            DenseMatrix doub = pisP.get(i);
                            double[][] matrix = Matrices.getArray((Matrix)doub);
                            int j = 0;
                            while (j < doub.numColumns()) {
                                ans = String.valueOf(ans) + String.format("%6.4f", matrix[0][j]) + "|";
                                ++j;
                            }
                            ans = String.valueOf(ans) + "}\n";
                            ++i;
                        }
                        JOptionPane.showMessageDialog(this, ans, "Steady State Probabilities", 1);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        } else if (message.equals("Cancel")) {
            this.dispose();
        }
    }

    public ArrayList<String> getNames(ArrayList<PhaseVarInfo> vars) {
        ArrayList<String> names = new ArrayList<String>();
        for (PhaseVarInfo var : vars) {
            names.add(var.varName);
        }
        return names;
    }

    public PhaseVarInfo getVar(String name) {
        for (PhaseVarInfo var : this.variables) {
            if (!var.varName.equals(name)) continue;
            return var;
        }
        return null;
    }
}

