/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jphase.GUI.DistributionDialog;
import jphase.GUI.GenerateVarFrame;
import jphase.GUI.GeneratorDialog;
import jphase.GUI.UniformDialog;
import jphase.GeneratorLEcuyer;
import jphase.distributions.IDistribution;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;

class GeneratorPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -3025450020220478855L;
    public static final String cantidad = "Number of variables to generate: ";
    public static final String algU = "The uniform random variable generator is ";
    public static final String distC = "The distribution is set on ";
    public static final String genC = "The generator to use is ";
    public static final String CAMBIAR = "Change";
    public static final String UBICACION = "Specify a location to save the file";
    public static final String NAME = "Specify a file name";
    public GenerateVarFrame ventana;
    public JLabel cantidadV;
    public JTextField cantF;
    public JLabel nombre;
    public JTextField nombreF;
    public JLabel algoUni;
    public JButton algoUniB;
    public JLabel dist;
    public JButton distB;
    public JLabel modGen;
    public JButton modGenB;
    public JLabel guardar;
    public JButton guardarB;
    public GeneratorLEcuyer generador;
    public UniformDialog diaUnif;
    public DistributionDialog diaDiast;
    private JFileChooser selector;
    public String ubicacion = "./data/";

    public GeneratorPanel(GenerateVarFrame ventanaX, GeneratorLEcuyer generador2) {
        this.ventana = ventanaX;
        this.generador = generador2;
        JPanel izq = new JPanel();
        JPanel der = new JPanel();
        this.cantidadV = new JLabel(cantidad);
        this.cantF = new JTextField("1000");
        this.nombre = new JLabel(NAME);
        this.nombreF = new JTextField("" + System.currentTimeMillis());
        this.algoUni = new JLabel(algU + this.generador.uniforme);
        this.algoUniB = new JButton(CAMBIAR);
        this.algoUniB.setActionCommand("Changeu");
        this.algoUniB.addActionListener(this);
        this.dist = new JLabel(distC + this.generador.distribucion);
        this.distB = new JButton(CAMBIAR);
        this.distB.setActionCommand("Changed");
        this.distB.addActionListener(this);
        this.modGen = new JLabel(genC + this.generador.getGenerador().toString().split("with")[0].trim());
        this.modGenB = new JButton(CAMBIAR);
        this.modGenB.setActionCommand("Changeg");
        this.modGenB.addActionListener(this);
        this.guardar = new JLabel(UBICACION);
        this.guardarB = new JButton("Select");
        this.guardarB.setActionCommand("Changes");
        this.guardarB.addActionListener(this);
        this.setLayout(new BorderLayout());
        izq.setLayout(new GridLayout(6, 1));
        der.setLayout(new GridLayout(6, 1));
        izq.add(this.cantidadV);
        der.add(this.cantF);
        izq.add(this.algoUni);
        der.add(this.algoUniB);
        izq.add(this.dist);
        der.add(this.distB);
        izq.add(this.modGen);
        der.add(this.modGenB);
        izq.add(this.guardar);
        der.add(this.guardarB);
        izq.add(this.nombre);
        der.add(this.nombreF);
        this.add((Component)izq, "West");
        this.add((Component)der, "East");
    }

    public String darNombre() {
        String nombre = this.nombreF.getText();
        return nombre.equals("") ? "" + System.currentTimeMillis() : nombre;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String evento = arg0.getActionCommand();
        if (evento.equals("Changeu")) {
            this.cambiarUni();
        } else if (evento.equals("Changed")) {
            this.cambiarDistribucion();
        } else if (evento.equals("Changeg")) {
            this.cambiarGenerador();
        } else if (evento.equals("Changes")) {
            this.cambiarUbicacion();
        }
    }

    private void cambiarGenerador() {
        GeneratorDialog diaGen = new GeneratorDialog(this.generador, this);
        diaGen.setVisible(true);
        this.setEnabled(false);
    }

    private void cambiarDistribucion() {
        if (this.diaDiast == null) {
            this.diaDiast = new DistributionDialog(this.generador, this);
        }
        this.diaDiast.setVisible(true);
        this.setEnabled(false);
    }

    private void cambiarUni() {
        if (this.diaUnif == null) {
            this.diaUnif = new UniformDialog(this.generador, this);
        }
        this.diaUnif.setVisible(true);
        this.setEnabled(false);
    }

    public void setAlgoUni(String algoUniT) {
        this.generador.setUniforme(algoUniT);
        this.algoUni.setText(algU + algoUniT);
    }

    public void setDist(String distT, ArrayList<Double> parametros) {
        this.dist.setText(distC + distT);
        this.actualizarGen(distT, parametros);
    }

    private void actualizarGen(String distT, ArrayList<Double> parametros) {
        IDistribution dist = this.generador.darDistribucion(distT, parametros);
        RandomVariateGen g = dist.darGenerador(this.generador.randomStream, null);
        this.setGen(g.toString());
    }

    public void setGen(String modGenT) {
        RandomVariateGen di = this.generador.getDistribucion().darGenerador(this.generador.randomStream, modGenT);
        this.modGen.setText(genC + di.toString().split("with")[0].trim());
    }

    public GeneratorLEcuyer getGenerator() {
        return this.generador;
    }

    @Override
    public String toString() {
        return "Generador de V.A.";
    }

    public String darInfoUnif(String evento) {
        return this.generador.darInfoUnif(evento);
    }

    public void reEnable() {
        this.setEnabled(true);
    }

    public void setEnable(Boolean bool) {
        this.algoUniB.setEnabled(bool);
        this.distB.setEnabled(bool);
        this.modGenB.setEnabled(bool);
        this.guardarB.setEnabled(bool);
    }

    public String darNumero() {
        return this.cantF.getText();
    }

    public void cambiarUbicacion() {
        this.selector = new JFileChooser();
        this.selector.setCurrentDirectory(new File("./data/"));
        this.selector.setDialogTitle("Select the folder");
        this.selector.setFileSelectionMode(1);
        this.selector.setAcceptAllFileFilterUsed(false);
        if (this.selector.showOpenDialog(this) == 0) {
            this.ubicacion = this.selector.getSelectedFile().toString();
        }
    }

    public String darUbicacion() {
        return this.ubicacion;
    }
}

