/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jphase.FittingLEcuyer;
import jphase.GUI.FitDistributionDialog;
import jphase.GUI.FitResultDialog;
import jphase.GUI.GenerateVarFrame;
import jphase.values.FitResult;

class GOFPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final String SELECT = "Select";
    private final String CHANGE = "Change";
    public final String ACEPT = "Acept";
    public final String CANCEL = "Close";
    public GenerateVarFrame interfaz;
    public JDialog dialogDist;
    public JLabel sizeV;
    public JTextField cantF;
    public JLabel percentage;
    public JTextField perc;
    public JLabel change;
    public JButton changeB;
    public JLabel save;
    public JButton saveB;
    public JButton ACEPTB;
    public JButton CANCELB;
    private FittingLEcuyer fitting;
    private String ruta;
    private String distribucion;

    public GOFPanel(GenerateVarFrame ventanaX, FittingLEcuyer fiting) {
        this.interfaz = ventanaX;
        this.distribucion = "Normal";
        this.ACEPTB = new JButton("Acept");
        this.ACEPTB.setActionCommand("Acept");
        this.ACEPTB.addActionListener(this);
        this.CANCELB = new JButton("Close");
        this.CANCELB.setActionCommand("Close");
        this.CANCELB.addActionListener(this);
        this.fitting = fiting;
        JPanel izq = new JPanel();
        JPanel der = new JPanel();
        this.sizeV = new JLabel("Number of groups fot the Chi-Sqare test");
        this.cantF = new JTextField("10");
        this.percentage = new JLabel("Percentaje of data shown in the graph");
        this.perc = new JTextField("90");
        this.save = new JLabel("Select the file with the data");
        this.saveB = new JButton("Select");
        this.saveB.setActionCommand("Select");
        this.saveB.addActionListener(this);
        this.change = new JLabel("Select a Distribucion");
        this.changeB = new JButton("Change");
        this.changeB.setActionCommand("Change");
        this.changeB.addActionListener(this);
        this.setLayout(new BorderLayout());
        izq.setLayout(new GridLayout(4, 1));
        der.setLayout(new GridLayout(4, 1));
        izq.add(this.sizeV);
        der.add(this.cantF);
        izq.add(this.percentage);
        der.add(this.perc);
        izq.add(this.save);
        der.add(this.saveB);
        izq.add(this.change);
        der.add(this.changeB);
        JPanel norte = new JPanel();
        norte.setLayout(new BorderLayout());
        JPanel sur = new JPanel();
        sur.add((Component)this.CANCELB, "West");
        sur.add((Component)this.ACEPTB, "East");
        norte.add((Component)izq, "West");
        norte.add((Component)der, "East");
        this.add((Component)sur, "South");
        this.add((Component)norte, "North");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String evento = e.getActionCommand();
        if (evento.equals("Acept")) {
            int n = 0;
            double p = 95.0;
            try {
                n = Integer.parseInt(this.cantF.getText());
                p = Double.parseDouble(this.perc.getText());
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Wrong number of groups", "Error", 0);
            }
            if (n <= 0 || p <= 0.0 || p > 100.0) {
                JOptionPane.showMessageDialog(this, "Wrong number of groups", "Error", 0);
            } else {
                this.fit(n, p);
            }
        } else if (evento.equals("Close")) {
            this.interfaz.dispose();
        } else if (evento.equals("Select")) {
            this.selectFile();
        } else if (evento.equals("Change")) {
            this.selectDistribution();
        }
    }

    private void fit(int n, double p) {
        if (this.ruta == null || this.distribucion == null) {
            JOptionPane.showMessageDialog(this, "Select a file and a distribution", "Error", 0);
            if (this.ruta == null) {
                this.selectFile();
            }
            if (this.distribucion == null) {
                this.selectDistribution();
            }
        } else {
            FitResult result = this.fitting.fit(n, this.ruta, this.distribucion, p);
            FitResultDialog dial = new FitResultDialog(result);
            dial.setVisible(true);
        }
    }

    private void selectDistribution() {
        if (this.dialogDist == null) {
            this.dialogDist = new FitDistributionDialog(this.fitting, this);
        }
        this.dialogDist.setVisible(true);
    }

    private void selectFile() {
        JFileChooser selector = new JFileChooser();
        selector.setDialogTitle("Select a File");
        selector.setFileSelectionMode(0);
        selector.setAcceptAllFileFilterUsed(false);
        if (selector.showOpenDialog(this) == 0) {
            this.ruta = selector.getSelectedFile().toString();
        }
    }

    public void setDistribucion(String distri) {
        this.distribucion = distri;
    }

    public String getDistribucion() {
        return this.distribucion;
    }
}

