/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jphase.distributions.IDistribution;
import jphase.values.FitResult;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

class FitResultDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String ACEPTAR = "Ok";
    private static final String SAVE = "Save";
    private static double max;
    private FitResult resultado;
    private JPanel estadisticos;
    private ChartPanel grafico;
    private ChartPanel grafico2;
    private JFreeChart chart;
    private DefaultTableXYDataset dataset2;
    private JButton aceptar;
    private JButton salvar;

    public FitResultDialog(FitResult resul) {
        this.setDefaultCloseOperation(2);
        this.resultado = resul;
        this.aceptar = new JButton(ACEPTAR);
        this.aceptar.setActionCommand(ACEPTAR);
        this.aceptar.addActionListener(this);
        this.salvar = new JButton("Save histogram");
        this.salvar.setActionCommand(SAVE);
        this.salvar.addActionListener(this);
        this.inicializarEstadisticos();
        this.inicializarHistograma();
        JPanel ajusteN = new JPanel();
        ajusteN.add((Component)this.estadisticos, "West");
        ajusteN.add((Component)this.grafico, "East");
        this.add((Component)ajusteN, "North");
        JPanel aux = new JPanel();
        aux.add((Component)this.aceptar, "East");
        aux.add((Component)this.salvar, "West");
        this.add((Component)aux, "South");
        this.setSize(800, 400);
        this.setLocationRelativeTo(null);
    }

    private void inicializarHistograma() {
        max = this.resultado.getP();
        HistogramDataset dataset = new HistogramDataset();
        double[] vector = FitResultDialog.darMax(this.resultado.getData());
        dataset.addSeries((Comparable)((Object)"Data (Histogram)"), vector, this.resultado.getGroups());
        this.chart = ChartFactory.createHistogram((String)"Data (Histogram)", (String)"x", (String)"f(x)", (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
        double min = this.chart.getXYPlot().getDomainAxis().getLowerBound();
        double max = this.chart.getXYPlot().getDomainAxis().getUpperBound();
        this.dataset2 = this.resultado.getDistribucion().getPDF(min, max, 200);
        renderer.setDrawBarOutline(false);
        JFreeChart chart2 = ChartFactory.createXYLineChart((String)"Fit result", (String)"x", (String)"f(x)", (XYDataset)this.dataset2, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        XYPlot plot2 = (XYPlot)chart2.getPlot();
        XYItemRenderer renderer2 = plot2.getRenderer();
        NumberAxis domain2 = new NumberAxis();
        plot2.setDataset(1, (XYDataset)dataset);
        plot2.setRenderer(1, (XYItemRenderer)renderer);
        plot2.setRangeAxis(1, (ValueAxis)domain2);
        plot2.mapDatasetToRangeAxis(1, 1);
        this.grafico = new ChartPanel(chart2);
        this.chart = this.grafico.getChart();
        this.grafico.setPreferredSize(new Dimension(500, 300));
    }

    private void inicializarEstadisticos() {
        this.estadisticos = new JPanel();
        this.estadisticos.setLayout(new GridLayout(6, 1));
        this.estadisticos.add(new JLabel("Square Error: " + Math.rint(this.resultado.getSqrError() * 1000.0) / 1000.0));
        this.estadisticos.add(new JLabel("\t(Reject if P-value < 0.05)"));
        this.estadisticos.add(new JLabel("\tChi2 P-Value: " + Math.rint(this.resultado.getChi2() * 1000.0) / 1000.0));
        this.estadisticos.add(new JLabel("\tK-S P-Value: " + Math.rint(this.resultado.getKs() * 1000.0) / 1000.0));
        this.estadisticos.add(new JLabel("File name: " + this.resultado.getNombre()));
        IDistribution distrib = this.resultado.getDistribucion();
        this.setTitle(distrib.aString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String evento = e.getActionCommand();
        if (evento.equals(ACEPTAR)) {
            this.dispose();
        } else if (evento.equals(SAVE)) {
            this.saveGraph();
        }
    }

    public void saveGraph() {
        try {
            File file = new File(".\\data\\histogram" + this.resultado.getNombre() + ".jpg");
            ChartUtilities.saveChartAsJPEG((File)file, (JFreeChart)this.chart, (int)500, (int)475);
            JOptionPane.showMessageDialog(this, "The histogram was succesfully created:\n\t" + file.getAbsolutePath(), "Done", 1);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "There were problems creating the histogram", "Error", 0);
        }
    }

    public static double[] darMax(double[] unift) {
        int i = unift.length;
        while (i > 0) {
            int j = 0;
            while (j < i - 1) {
                double p1 = unift[j];
                double p2 = unift[j + 1];
                if (p1 > p2) {
                    unift[j] = p2;
                    unift[j + 1] = p1;
                }
                ++j;
            }
            --i;
        }
        int pos = (int)((double)unift.length * max / 100.0);
        double[] list = new double[pos];
        int i2 = 0;
        while (i2 != pos) {
            list[i2] = unift[i2];
            ++i2;
        }
        return list;
    }
}

