/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import jphase.fit.MomentsACPH2Fit;

public class FitFrame
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel principalPanel;
    JLabel alertLabel;
    JLabel fileLabel;
    JButton fileButton;
    JFileChooser fileChooser;
    JLabel[] paramNames;
    JTextField[] paramValues;
    JButton yesButton;
    JButton noButton;
    private boolean res = false;
    private double[] data;
    private boolean needPar;
    private int width = 360;
    private int height = 150;

    public FitFrame(String fitType) {
        int i;
        this.setTitle("JPhase - New Fit Parameters");
        this.setResizable(false);
        this.setModal(true);
        this.principalPanel = new JPanel();
        this.principalPanel.setLayout(null);
        this.principalPanel.setPreferredSize(new Dimension(this.width, this.height));
        this.principalPanel.setOpaque(true);
        this.alertLabel = new JLabel("Parameters of the " + fitType + " Fit");
        this.alertLabel.setBounds(new Rectangle(this.width / 2 - 110, 10, 260, 20));
        this.alertLabel.setFont(new Font("@Arial Unicode MS", 1, 12));
        this.alertLabel.setOpaque(true);
        this.principalPanel.add((Component)this.alertLabel, null);
        this.fileLabel = new JLabel("File Load");
        this.fileLabel.setBounds(new Rectangle(this.width / 2 - 110, 40, 100, 20));
        this.fileLabel.setFont(new Font("@Arial Unicode MS", 1, 12));
        this.principalPanel.add((Component)this.fileLabel, null);
        this.fileButton = new JButton("Browse");
        this.fileButton.setBounds(new Rectangle(this.width / 2, 40, 100, 25));
        this.fileButton.setFont(new Font("@Arial Unicode MS", 1, 12));
        this.fileButton.addActionListener(new ParamFrame_fileButton_actionAdapter(this));
        this.principalPanel.add((Component)this.fileButton, null);
        if (fitType.equals("Moments ACPH2")) {
            this.paramNames = new JLabel[1];
            this.paramNames[0] = new JLabel("Precision");
            this.paramNames[0].setFont(new Font("@Arial Unicode MS", 1, 12));
            this.paramValues = new JTextField[1];
            this.paramValues[0] = new JTextField("" + MomentsACPH2Fit.precision);
            i = 0;
            while (i < this.paramNames.length) {
                this.paramNames[i].setBounds(new Rectangle(this.width / 2 - 100, 40 * (i + 2), 100, 20));
                this.principalPanel.add((Component)this.paramNames[i], null);
                this.paramValues[i].setBackground(Color.WHITE);
                this.paramValues[i].setBounds(new Rectangle(this.width / 2, 40 * (i + 2), 100, 20));
                this.principalPanel.add((Component)this.paramValues[i], null);
                ++i;
            }
        } else if (fitType.equals("Moments EC Complete")) {
            this.needPar = true;
            this.paramNames = new JLabel[1];
            this.paramNames[0] = new JLabel("Precision");
            this.paramNames[0].setFont(new Font("@Arial Unicode MS", 1, 12));
            this.paramValues = new JTextField[1];
            this.paramValues[0] = new JTextField("" + MomentsACPH2Fit.precision);
            i = 0;
            while (i < this.paramNames.length) {
                this.paramNames[i].setBounds(new Rectangle(this.width / 2 - 100, 40 * (i + 2), 100, 20));
                this.principalPanel.add((Component)this.paramNames[i], null);
                this.paramValues[i].setBackground(Color.WHITE);
                this.paramValues[i].setBounds(new Rectangle(this.width / 2, 40 * (i + 2), 100, 20));
                this.principalPanel.add((Component)this.paramValues[i], null);
                ++i;
            }
        } else if (fitType.equals("Moments EC Positive")) {
            this.paramNames = new JLabel[1];
            this.paramNames[0] = new JLabel("Precision");
            this.paramNames[0].setFont(new Font("@Arial Unicode MS", 1, 12));
            this.paramValues = new JTextField[1];
            this.paramValues[0] = new JTextField("" + MomentsACPH2Fit.precision);
            i = 0;
            while (i < this.paramNames.length) {
                this.paramNames[i].setBounds(new Rectangle(this.width / 2 - 100, 40 * (i + 2), 100, 20));
                this.principalPanel.add((Component)this.paramNames[i], null);
                this.paramValues[i].setBackground(Color.WHITE);
                this.paramValues[i].setBounds(new Rectangle(this.width / 2, 40 * (i + 2), 100, 20));
                this.principalPanel.add((Component)this.paramValues[i], null);
                ++i;
            }
        } else if (fitType.equals("Moments ACPH")) {
            this.paramNames = new JLabel[1];
            this.paramNames[0] = new JLabel("Precision");
            this.paramNames[0].setFont(new Font("@Arial Unicode MS", 1, 12));
            this.paramValues = new JTextField[1];
            this.paramValues[0] = new JTextField("" + MomentsACPH2Fit.precision);
            i = 0;
            while (i < this.paramNames.length) {
                this.paramNames[i].setBounds(new Rectangle(this.width / 2 - 100, 40 * (i + 2), 100, 20));
                this.principalPanel.add((Component)this.paramNames[i], null);
                this.paramValues[i].setBackground(Color.WHITE);
                this.paramValues[i].setBounds(new Rectangle(this.width / 2, 40 * (i + 2), 100, 20));
                this.principalPanel.add((Component)this.paramValues[i], null);
                ++i;
            }
        } else if (fitType.equals("EMHyperExpoFit")) {
            this.needPar = false;
        } else if (fitType.equals("EMHyperErlangFit")) {
            this.needPar = false;
        } else if (fitType.equals("EMPhaseFit")) {
            this.needPar = false;
        } else {
            System.out.println("Non-known fitting algorithm");
        }
        this.yesButton = new JButton("Enter");
        this.yesButton.setBounds(new Rectangle(this.width / 2 - 100, this.height - 40, 80, 25));
        this.yesButton.addActionListener(new ParamFrame_yesButton_actionAdapter(this));
        this.yesButton.setOpaque(true);
        this.principalPanel.add((Component)this.yesButton, null);
        this.noButton = new JButton("Cancel");
        this.noButton.setBounds(new Rectangle(this.width / 2 + 20, this.height - 40, 80, 25));
        this.noButton.addActionListener(new ParamFrame_noButton_actionAdapter(this));
        this.principalPanel.add((Component)this.noButton, null);
        this.getContentPane().add((Component)this.principalPanel, "Center");
        this.centrarFrame();
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
    }

    public boolean getRes() {
        return this.res;
    }

    public double[] getData() {
        return this.data;
    }

    void fileButton_actionPerformed(ActionEvent e) {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setBounds(new Rectangle(this.width / 2 - 20, 40, 100, 20));
        this.fileChooser.setDialogType(2);
        this.fileChooser.setDialogTitle("Load data File for fitting procedure");
        this.fileChooser.setFileFilter(new TextFilter());
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            System.out.println("You chose to open this file: " + this.fileChooser.getSelectedFile().getName());
        }
        this.data = this.readTextFile(this.fileChooser.getSelectedFile().getAbsolutePath());
    }

    private double[] readTextFile(String nombreArchivo) {
        ArrayList<Double> data = new ArrayList<Double>();
        try {
            FileReader archivo = new FileReader(nombreArchivo);
            BufferedReader entrada = new BufferedReader(archivo);
            while (entrada.ready()) {
                String s = entrada.readLine();
                StringTokenizer str = new StringTokenizer(s);
                if (str.countTokens() != 1) {
                    throw new Exception();
                }
                data.add(new Double(Double.parseDouble(str.nextToken())));
            }
            entrada.close();
            archivo.close();
        }
        catch (Exception e) {
            System.out.println("Data file could not be read.");
            return null;
        }
        double[] datos = new double[data.size()];
        int i = 0;
        while (i < data.size()) {
            datos[i] = (Double)data.get(i);
            ++i;
        }
        return datos;
    }

    void yesButton_actionPerformed(ActionEvent e) {
        if (this.paramValues != null && this.needPar) {
            int i = 0;
            while (i < this.paramValues.length) {
                if (this.paramValues[i].getText().equals("")) {
                    JOptionPane.showMessageDialog(null, "You must enter ALL the Parameters", "JPhase Alert", 1);
                } else {
                    this.res = true;
                    this.setVisible(false);
                }
                ++i;
            }
        } else if (!this.needPar) {
            if (this.data == null) {
                JOptionPane.showMessageDialog(null, "You must select the data file", "JPhase Alert", 1);
            } else {
                this.res = true;
                this.paramValues = new JTextField[0];
                this.setVisible(false);
            }
        }
    }

    void noButton_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void centrarFrame() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - this.width) / 2, (screenSize.height - this.height) / 2);
    }

    private String getSuffix(File f) {
        String s = f.getPath();
        String suffix = null;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            suffix = s.substring(i + 1).toLowerCase();
        }
        return suffix;
    }

    class ParamFrame_fileButton_actionAdapter
    implements ActionListener {
        FitFrame adaptee;

        ParamFrame_fileButton_actionAdapter(FitFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.fileButton_actionPerformed(e);
        }
    }

    class ParamFrame_noButton_actionAdapter
    implements ActionListener {
        FitFrame adaptee;

        ParamFrame_noButton_actionAdapter(FitFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.noButton_actionPerformed(e);
        }
    }

    class ParamFrame_yesButton_actionAdapter
    implements ActionListener {
        FitFrame adaptee;

        ParamFrame_yesButton_actionAdapter(FitFrame adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.adaptee.yesButton_actionPerformed(e);
        }
    }

    class TextFilter
    extends FileFilter {
        TextFilter() {
        }

        @Override
        public boolean accept(File f) {
            String suffix;
            boolean accept = f.isDirectory();
            if (!accept && (suffix = FitFrame.this.getSuffix(f)) != null) {
                accept = suffix.equals("txt");
            }
            return accept;
        }

        @Override
        public String getDescription() {
            return "Archivos de texto(*.txt)";
        }
    }
}

