/*
 * Decompiled with CFR 0.152.
 */
package jphase.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jphase.GUI.GeneratorPanel;
import jphase.GUI.ParametersDialog;
import jphase.GeneratorLEcuyer;
import jphase.distributions.IDistribution;

class DistributionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public final String ACEPTAR = "Acept";
    public final String CANCELAR = "Cancel";
    public GeneratorPanel panel;
    public GeneratorLEcuyer gen;
    public ButtonGroup grupo;
    public JButton aceptarB;
    public JButton cancelarB;
    public ArrayList<JRadioButton> botones;
    public ArrayList<JButton> info;
    public ArrayList<String> distribuciones;
    public String distri;

    public DistributionDialog(GeneratorLEcuyer genle, GeneratorPanel pan) {
        this.panel = pan;
        this.gen = genle;
        this.aceptarB = new JButton("Acept");
        this.aceptarB.setActionCommand("Acept");
        this.aceptarB.addActionListener(this);
        this.cancelarB = new JButton("Cancel");
        this.cancelarB.setActionCommand("Cancel");
        this.cancelarB.addActionListener(this);
        this.distribuciones = this.gen.darDistribuciones();
        this.botones = new ArrayList();
        this.grupo = new ButtonGroup();
        JPanel pan2 = new JPanel();
        pan2.setLayout(new GridLayout(this.distribuciones.size() + 1, 1));
        this.setSize(200, this.distribuciones.size() * 30 + 50);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        int i = 0;
        while (i != this.distribuciones.size()) {
            String nom = this.distribuciones.get(i);
            JRadioButton boton = new JRadioButton(nom);
            this.grupo.add(boton);
            this.botones.add(boton);
            pan2.add(boton);
            boton.setSelected(false);
            if (i == 0) {
                boton.setSelected(true);
            }
            ++i;
        }
        JPanel pan1 = new JPanel();
        pan1.setLayout(new GridLayout(1, 2));
        pan1.setSize(250, 85);
        pan1.add(this.cancelarB);
        pan1.add(this.aceptarB);
        this.add((Component)pan2, "North");
        this.add((Component)pan1, "South");
        this.setLocationRelativeTo(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String evento = e.getActionCommand();
        if (evento.equals("Acept")) {
            int j = 0;
            int i = 0;
            while (i != this.botones.size()) {
                if (this.botones.get(i).isSelected()) {
                    j = i;
                    break;
                }
                ++i;
            }
            this.distri = this.distribuciones.get(j);
            this.setEnabled(false);
            IDistribution iDist = this.gen.darDistribucion(this.distri, null);
            this.gen.setDistribucion(iDist);
            ArrayList<String> lista = iDist.darParametros();
            ParametersDialog diap = new ParametersDialog(lista, this);
            diap.setVisible(true);
        } else if (evento.equals("Cancel")) {
            this.dispose();
        }
    }

    public void reactivar() {
        this.setEnabled(true);
    }

    public void establecerParametros(ArrayList<Double> valores) {
        this.gen.setDistribucion(this.distri, valores);
        this.panel.setDist(this.gen.getDistribucion().toString(), valores);
        this.dispose();
    }

    @Override
    public void dispose() {
        this.panel.reEnable();
        super.dispose();
    }
}

