/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import cern.colt.list.DoubleArrayList;
import java.io.File;
import java.util.ArrayList;
import jphase.GUI.PhaseVarInfo;
import jphase.PhaseVar;
import jphase.distributions.DistributionManager;
import jphase.distributions.IDistribution;
import jphase.values.FitResult;
import jphase.values.ReaderWriter;
import umontreal.iro.lecuyer.gof.GofStat;
import umontreal.iro.lecuyer.probdist.ChiSquareDist;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.KolmogorovSmirnovDist;

public class FittingLEcuyer {
    private DistributionManager manager = new DistributionManager();

    public static DoubleArrayList ordenamiento(DoubleArrayList unift) {
        int i = unift.size();
        while (i > 0) {
            int j = 0;
            while (j < i - 1) {
                double p2;
                double p1 = unift.get(j);
                if (p1 > (p2 = unift.get(j + 1))) {
                    unift.set(j, p2);
                    unift.set(j + 1, p1);
                }
                ++j;
            }
            --i;
        }
        return unift;
    }

    public FitResult fit(int n, String ruta, String distribucion, double p) {
        double[] d = ReaderWriter.saveFileToVector(ruta);
        DoubleArrayList data = new DoubleArrayList(d);
        ContinuousDistribution cont = this.ajusteDis(distribucion, data);
        DoubleArrayList unift = GofStat.unifTransform((DoubleArrayList)data, (ContinuousDistribution)cont);
        DoubleArrayList sortedData = FittingLEcuyer.ordenamiento(unift);
        int gl = n;
        int tamano = unift.size() / gl;
        double estim = GofStat.chi2Equal((DoubleArrayList)unift, (double)tamano);
        double[] ksEstim = GofStat.kolmogorovSmirnov((DoubleArrayList)sortedData);
        ChiSquareDist dist = new ChiSquareDist(gl);
        KolmogorovSmirnovDist dist2 = new KolmogorovSmirnovDist(sortedData.size());
        double pvalue = 1.0 - dist.cdf(estim);
        double pvalueKS = 1.0 - dist2.cdf(ksEstim[2]);
        File f = new File(ruta);
        IDistribution distribu = this.manager.darDistribucion(distribucion, this.darArray(cont.getParams()));
        return new FitResult(estim, pvalue, pvalueKS, n, f.getName(), distribu, data.elements(), p);
    }

    private ArrayList<Double> darArray(double[] params) {
        ArrayList<Double> retorna = new ArrayList<Double>();
        int i = 0;
        while (i != params.length) {
            retorna.add(params[i]);
            ++i;
        }
        return retorna;
    }

    public FitResult fit(int n, double[] d, String distribucion, double p) {
        DoubleArrayList data = new DoubleArrayList(d);
        ContinuousDistribution cont = this.ajusteDis(distribucion, data);
        DoubleArrayList unift = GofStat.unifTransform((DoubleArrayList)data, (ContinuousDistribution)cont);
        DoubleArrayList sortedData = FittingLEcuyer.ordenamiento(unift);
        int gl = n;
        int tamano = unift.size() / gl;
        double estim = GofStat.chi2Equal((DoubleArrayList)unift, (double)tamano);
        double[] ksEstim = GofStat.kolmogorovSmirnov((DoubleArrayList)sortedData);
        ChiSquareDist dist = new ChiSquareDist(gl);
        KolmogorovSmirnovDist dist2 = new KolmogorovSmirnovDist(sortedData.size());
        double pvalue = 1.0 - dist.cdf(estim);
        double pvalueKS = 1.0 - dist2.cdf(ksEstim[2]);
        IDistribution distribu = this.manager.darDistribucion(distribucion, this.darArray(cont.getParams()));
        return new FitResult(estim, pvalue, pvalueKS, n, "null", distribu, data.elements(), p);
    }

    public FitResult fitPhases(PhaseVarInfo var, String file, int number, double p) {
        double[] dataX = ReaderWriter.saveFileToVector(file);
        DoubleArrayList data = new DoubleArrayList(dataX);
        double[] obs = new double[number];
        double[] est = new double[number];
        double min = dataX[0];
        double max = dataX[0];
        int j = 0;
        while (j != dataX.length) {
            double dato = dataX[j];
            if (dato < min) {
                min = dato;
            }
            if (dato > max) {
                max = dato;
            }
            ++j;
        }
        double inter = (max - min) / (double)number;
        PhaseVar var0 = var.var;
        int i = 0;
        while (i != number) {
            double nmax = min + inter * (double)(i + 1);
            double cdf = var0.prob(inter * (double)i, nmax);
            est[i] = cdf * (double)dataX.length;
            ++i;
        }
        int j2 = 0;
        while (j2 != dataX.length) {
            double dato = dataX[j2];
            int i2 = 0;
            while (i2 != number) {
                if (min + inter * (double)i2 <= dato && dato <= min + inter * (double)(i2 + 1)) {
                    int n = i2;
                    obs[n] = obs[n] + 1.0;
                }
                ++i2;
            }
            ++j2;
        }
        double sum = 0.0;
        double sum1 = 0.0;
        int i3 = 0;
        while (i3 != number) {
            sum += Math.pow(obs[i3] - est[i3], 2.0) / est[i3];
            sum1 += Math.pow(obs[i3] - est[i3], 2.0);
            ++i3;
        }
        sum1 /= (double)number;
        ChiSquareDist dist = new ChiSquareDist(number);
        double pvalue = 0.0;
        if (!"NaN".equals("" + sum)) {
            pvalue = 1.0 - dist.cdf(sum);
        }
        return new FitResult(sum1, pvalue, number, var, data.elements(), p);
    }

    private ContinuousDistribution ajusteDis(String distribucion, DoubleArrayList data) {
        return this.manager.ajustarParametros(distribucion, data);
    }

    public ArrayList<String> darDistribuciones() {
        return this.manager.darDistribuciones();
    }
}

