/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import jphase.AbstractContPhaseVar;
import jphase.ContPhaseVar;
import jphase.DenseContPhaseVar;
import jphase.MatrixUtils;
import jphase.PhaseVar;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public class ErlangCoxianVar
extends AbstractContPhaseVar
implements PhaseVar {
    private int n;
    private double p;
    private double lambdaY;
    private double lambdaX1;
    private double lambdaX2;
    private double px;

    public ErlangCoxianVar() {
        this.n = 3;
        this.p = 1.0;
        this.lambdaY = 1.0;
        this.lambdaX1 = 1.0;
        this.lambdaX2 = 1.0;
        this.px = 1.0;
    }

    public ErlangCoxianVar(int n, double p, double lambdaY, double lambdaX1, double lambdaX2, double px) {
        if (n < 1) {
            throw new IllegalArgumentException("The number of phases n must be >= 1");
        }
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("The probability p must be 0 <= p <= 1");
        }
        if (lambdaY < 0.0) {
            throw new IllegalArgumentException("The rate lambdaY must be >= 0");
        }
        if (lambdaX1 < 0.0) {
            throw new IllegalArgumentException("The rate lambdaX1 must be >= 0");
        }
        if (lambdaX2 < 0.0) {
            throw new IllegalArgumentException("The rate lambdaX2 must be >= 0");
        }
        if (px < 0.0 || px > 1.0) {
            throw new IllegalArgumentException("The probability px must be 0 <= px <= 1");
        }
        this.n = n;
        this.p = p;
        this.lambdaY = lambdaY;
        this.lambdaX1 = lambdaX1;
        this.lambdaX2 = lambdaX2;
        this.px = px;
    }

    public ErlangCoxianVar(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The number of phases n must be >= 1");
        }
        this.n = n;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public double getP() {
        return this.p;
    }

    public void setP(double p) {
        this.p = p;
    }

    public double getLambdaY() {
        return this.lambdaY;
    }

    public void setLambdaY(double lambdaY) {
        this.lambdaY = lambdaY;
    }

    public double getLambdaX1() {
        return this.lambdaX1;
    }

    public void setLambdaX1(double lambdaX1) {
        this.lambdaX1 = lambdaX1;
    }

    public double getLambdaX2() {
        return this.lambdaX2;
    }

    public void setLambdaX2(double lambdaX2) {
        this.lambdaX2 = lambdaX2;
    }

    public double getPx() {
        return this.px;
    }

    public void setPx(double px) {
        this.px = px;
    }

    @Override
    public Matrix getMatrix() {
        double[][] matriz = new double[this.n][this.n];
        if (this.n == 1) {
            matriz[0][0] = -this.lambdaX2;
        } else if (this.n == 2) {
            matriz[0][0] = -this.lambdaX1;
            matriz[0][1] = this.px * this.lambdaX1;
            matriz[1][1] = -this.lambdaX2;
        } else {
            int i = 0;
            while (i < this.n - 2) {
                matriz[i][i] = -this.lambdaY;
                matriz[i][i + 1] = this.lambdaY;
                ++i;
            }
            matriz[this.n - 2][this.n - 2] = -this.lambdaX1;
            matriz[this.n - 2][this.n - 1] = this.px * this.lambdaX1;
            matriz[this.n - 1][this.n - 1] = -this.lambdaX2;
        }
        return new DenseMatrix(matriz);
    }

    @Override
    public void setMatrix(Matrix A) {
    }

    @Override
    public Vector getVector() {
        double[] vector = new double[this.n];
        vector[0] = this.p;
        return new DenseVector(vector);
    }

    @Override
    public void setVector(Vector alpha) {
    }

    @Override
    public ContPhaseVar copy() {
        return new ErlangCoxianVar(this.n, this.p, this.lambdaY, this.lambdaX1, this.lambdaX2, this.px);
    }

    @Override
    public ContPhaseVar newVar(int n) {
        return new ErlangCoxianVar(n);
    }

    public PhaseVar mixtureExpo(double lambda, double p) {
        Matrix oldMat = this.getMatrix();
        Vector oldVec = this.getVector();
        DenseMatrix newMat = new DenseMatrix(this.n + 1, this.n + 1);
        DenseVector newVec = new DenseVector(this.n + 1);
        double[][] matrizExpo = new double[][]{{-lambda}};
        newMat = MatrixUtils.concatQuad(oldMat, (Matrix)new DenseMatrix(this.n, 1), (Matrix)new DenseMatrix(1, this.n), (Matrix)new DenseMatrix((double[][])matrizExpo), (Matrix)newMat);
        newVec.set(0, oldVec.get(0) * p);
        newVec.set(this.n, 1.0 - p);
        return new DenseContPhaseVar((Vector)newVec, (Matrix)newMat);
    }

    public PhaseVar convoExpo(double lambda) {
        Matrix oldMat = this.getMatrix();
        Vector oldVec = this.getVector();
        DenseMatrix newMat = new DenseMatrix(this.n + 1, this.n + 1);
        DenseVector newVec = new DenseVector(this.n + 1);
        double[][] matrizRightUp = new double[this.n][1];
        matrizRightUp[this.n - 1][0] = -this.lambdaX2;
        double[][] matrizExpo = new double[][]{{-lambda}};
        newMat = MatrixUtils.concatQuad(oldMat, (Matrix)new DenseMatrix(matrizRightUp), (Matrix)new DenseMatrix(1, this.n), (Matrix)new DenseMatrix((double[][])matrizExpo), (Matrix)newMat);
        newVec.set(0, oldVec.get(0));
        return new DenseContPhaseVar((Vector)newVec, (Matrix)newMat);
    }

    @Override
    public String description() {
        String s = "__________________________________________________\n";
        s = String.valueOf(s) + "ErlangCoxian Distribution";
        s = String.valueOf(s) + "\nNumber of Phases: " + this.n + "\n";
        s = String.valueOf(s) + "Probability of Positive time : " + this.p + "\n";
        s = String.valueOf(s) + "Erlang rate : " + this.lambdaY + "\n";
        s = String.valueOf(s) + "Coxian First stage rate : " + this.lambdaX1 + "\n";
        s = String.valueOf(s) + "Coxian Second stage rate : " + this.lambdaX2 + "\n";
        s = String.valueOf(s) + "NON-absorption Probability at Coxian First Stage : " + this.px + "\n";
        s = String.valueOf(s) + "__________________________________________________\n";
        return s;
    }
}

