/*
 * Decompiled with CFR 0.152.
 */
package jphase;

import jphase.ContPhaseVar;
import jphase.DiscPhaseVar;
import jphase.MatrixUtils;
import jphase.Utils;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.CG;
import no.uib.cipr.matrix.sparse.DefaultIterationMonitor;
import no.uib.cipr.matrix.sparse.IterationMonitor;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;

public abstract class AbstractContPhaseVar
implements ContPhaseVar {
    @Override
    public ContPhaseVar sumPH(DiscPhaseVar B, ContPhaseVar res) {
        int n3;
        int n2;
        int n1 = this.getNumPhases();
        if (n1 * (n2 = B.getNumPhases()) != (n3 = res.getNumPhases())) {
            throw new IndexOutOfBoundsException("The closure operation cannot be done:\n this.Phases * B.Phases != res.Phases (" + n1 + " * " + n2 + " != " + n3 + ")");
        }
        Matrix ISInv = Matrices.identity((int)n2).add(-this.getVec0(), B.getMatrix());
        ISInv = ISInv.solve((Matrix)Matrices.identity((int)n2), ISInv.copy());
        res.setVector(MatrixUtils.kroneckerVectors(this.getVector(), ISInv.transMult(B.getVector(), B.getVector().copy()), res.getVector()));
        Matrix L1 = MatrixUtils.kronecker(this.getMatrix(), (Matrix)Matrices.identity((int)n2), res.getMatrix().copy());
        Matrix L2 = MatrixUtils.kronecker(MatrixUtils.multVector(this.getMat0(), this.getVector(), this.getMatrix().copy()).scale(1.0 - this.getVec0()), ISInv.mult(B.getMatrix(), B.getMatrix().copy()), res.getMatrix().copy());
        res.setMatrix(L1.add(L2));
        return res;
    }

    @Override
    public ContPhaseVar sumPH(DiscPhaseVar v2) {
        int n1 = this.getNumPhases();
        int n2 = v2.getNumPhases();
        ContPhaseVar res = this.newVar(n1 * n2);
        return this.sumPH(v2, res);
    }

    @Override
    public int getNumPhases() {
        return this.getVector().size();
    }

    @Override
    public double getVec0() {
        return 1.0 - this.getVector().dot((Vector)MatrixUtils.OnesVector(this.getNumPhases()));
    }

    @Override
    public Vector getMat0() {
        return this.getMatrix().mult(-1.0, (Vector)MatrixUtils.OnesVector(this.getNumPhases()), this.getVector().copy());
    }

    @Override
    public double[][] getMatrixArray() {
        return Matrices.getArray((Matrix)this.getMatrix());
    }

    @Override
    public double[] getVectorArray() {
        return Matrices.getArray((Vector)this.getVector());
    }

    @Override
    public double[] getMat0Array() {
        return Matrices.getArray((Vector)this.getMat0());
    }

    @Override
    public double expectedValue() {
        return this.moment(1);
    }

    @Override
    public double variance() {
        double m1 = this.moment(1);
        return this.moment(2) - m1 * m1;
    }

    @Override
    public double stdDeviation() {
        return Math.sqrt(this.variance());
    }

    @Override
    public double CV() {
        double m = this.expectedValue();
        return this.moment(2) / (m * m) - 1.0;
    }

    @Override
    public double moment(int k) {
        double res = 0.0;
        Vector x = this.getVector().copy().zero();
        CG solv = new CG(x);
        Matrix A1 = MatrixUtils.matPower(this.getMatrix(), k).transpose();
        Matrix A = A1.copy().zero();
        A = A1.transAmult(A1, A);
        Vector b = A1.transMult(this.getVector(), this.getVector().copy());
        solv.setIterationMonitor((IterationMonitor)new DefaultIterationMonitor(100000, 1.0E-10, 1.0E-50, 100000.0));
        try {
            solv.solve(A, b, x);
            res = x.dot((Vector)MatrixUtils.OnesVector(this.getVector().size()));
        }
        catch (IterativeSolverNotConvergedException e) {
            System.out.println("Imposible to calculate moment " + k + "(" + e.getReason() + ")");
        }
        if (k % 2 != 0) {
            res = -res;
        }
        return res *= Utils.fact(k);
    }

    @Override
    public double cdf(double x) {
        return 1.0 - MatrixUtils.expTimesOnes(this.getMatrix(), x, this.getVector());
    }

    @Override
    public double[] cdf(int n, double delta) {
        double[] result = new double[n];
        double[] survivals = MatrixUtils.expTimesOnes(this.getMatrix(), n, delta, this.getVector());
        int i = 0;
        while (i < n) {
            result[i] = 1.0 - survivals[i];
            ++i;
        }
        return result;
    }

    @Override
    public double pdf(double x) {
        return MatrixUtils.exp(this.getMatrix(), x, this.getVector(), this.getMat0());
    }

    @Override
    public double[] pdf(int n, double delta) {
        return MatrixUtils.exp(this.getMatrix(), n, delta, this.getVector(), this.getMat0(), true);
    }

    @Override
    public double prob(double a, double b) {
        return b > a ? this.cdf(b) - this.cdf(a) : 0.0;
    }

    @Override
    public double survival(double x) {
        return 1.0 - this.cdf(x);
    }

    @Override
    public double[] survival(int n, double delta) {
        double[] cdfs = this.cdf(n, delta);
        double[] res = new double[n];
        int i = 0;
        while (i < n) {
            res[i] = 1.0 - cdfs[i];
            ++i;
        }
        return res;
    }

    @Override
    public double lossFunction1(double t) {
        double res = 0.0;
        Vector x = this.getVector().copy().zero();
        CG solv = new CG(x);
        Matrix A = this.getMatrix().copy();
        Matrix At = A.copy().zero();
        A.transpose(At);
        Matrix B = A.copy().zero();
        B = A.mult(At, B);
        Vector temp = x.copy();
        temp = MatrixUtils.exp(this.getMatrix(), t).mult((Vector)MatrixUtils.OnesVector(this.getNumPhases()), temp.copy());
        Vector b = A.mult(this.getVector(), x.copy().zero());
        solv.setIterationMonitor((IterationMonitor)new DefaultIterationMonitor(100000, 1.0E-10, 1.0E-50, 100000.0));
        try {
            solv.solve(B, b, x);
            res = x.dot(temp);
        }
        catch (IterativeSolverNotConvergedException e) {
            System.out.println("Imposible to calculate order-1 loss Function at " + t + "(" + e.getReason() + ")");
        }
        return -res;
    }

    @Override
    public double lossFunction2(double t) {
        double res = 0.0;
        Vector x = this.getVector().copy().zero();
        CG solv = new CG(x);
        Matrix A = MatrixUtils.matPower(this.getMatrix().copy(), 2);
        Matrix At = A.copy();
        A.transpose(At);
        Matrix B = A.copy().zero();
        B = At.mult(A, B);
        Vector temp = x.copy();
        temp = MatrixUtils.exp(this.getMatrix(), t).mult((Vector)MatrixUtils.OnesVector(this.getNumPhases()), temp);
        Vector b = At.mult(temp, x.copy());
        solv.setIterationMonitor((IterationMonitor)new DefaultIterationMonitor(100000, 1.0E-10, 1.0E-50, 100000.0));
        try {
            solv.solve(B, b, x);
            res = this.getVector().dot(x);
        }
        catch (IterativeSolverNotConvergedException e) {
            System.out.println("Imposible to calculate order-2 loss Function at " + t + "(" + e.getReason() + ")");
        }
        return res;
    }

    @Override
    public double quantil(double p) {
        int ITMAX = 100;
        double x = this.expectedValue();
        int cnt = 0;
        while (cnt < ITMAX) {
            double derv = this.pdf(x);
            double dif = this.cdf(x) - p;
            if (Math.abs(dif) < 1.0E-10) {
                return x;
            }
            x = Math.max(x - dif / derv, 0.0);
            ++cnt;
        }
        return 0.0;
    }

    @Override
    public double median() {
        return this.quantil(0.5);
    }

    @Override
    public ContPhaseVar sum(ContPhaseVar v2, ContPhaseVar res) {
        if (Matrices.cardinality((Vector)this.getVector()) == 0) {
            return v2;
        }
        if (Matrices.cardinality((Vector)v2.getVector()) == 0) {
            return this;
        }
        int n1 = this.getNumPhases();
        int n2 = v2.getNumPhases();
        Vector A0 = this.getMat0();
        Vector vec1 = this.getVector();
        double vec1_0 = this.getVec0();
        Vector vec2 = v2.getVector();
        Vector vec2Temp = vec2.copy();
        vec2Temp.scale(vec1_0);
        res.setVector(MatrixUtils.concatVectors(vec1, vec2Temp, res.getVector()));
        int[] zeroRowsLD = new int[n2];
        int[] zeroColsLD = new int[n1];
        int i = 0;
        while (i < n2) {
            zeroRowsLD[i] = n1 + i;
            ++i;
        }
        i = 0;
        while (i < n1) {
            zeroColsLD[i] = i;
            ++i;
        }
        int[] zeroRowsRU = new int[n1];
        int[] zeroColsRU = new int[n2];
        int i2 = 0;
        while (i2 < n1) {
            zeroRowsRU[i2] = i2;
            ++i2;
        }
        i2 = 0;
        while (i2 < n2) {
            zeroColsRU[i2] = n1 + i2;
            ++i2;
        }
        res.setMatrix(MatrixUtils.concatQuad(this.getMatrix(), MatrixUtils.multVector(A0, vec2, Matrices.getSubMatrix((Matrix)res.getMatrix(), (int[])zeroRowsRU, (int[])zeroColsRU)), Matrices.getSubMatrix((Matrix)res.getMatrix(), (int[])zeroRowsLD, (int[])zeroColsLD), v2.getMatrix(), res.getMatrix()));
        return res;
    }

    @Override
    public ContPhaseVar sum(ContPhaseVar v2) {
        int n1 = this.getNumPhases();
        int n2 = v2.getNumPhases();
        ContPhaseVar res = this.newVar(n1 + n2);
        return this.sum(v2, res);
    }

    @Override
    public ContPhaseVar sumGeom(double p) {
        ContPhaseVar res = this.copy();
        res.setVector(this.getVector());
        res.setMatrix(this.getMatrix().copy().add(1.0 - p, MatrixUtils.multVector(this.getMat0(), this.getVector(), res.getMatrix().copy().zero())));
        return res;
    }

    @Override
    public ContPhaseVar mix(double p, ContPhaseVar v2, ContPhaseVar res) {
        int n1 = this.getNumPhases();
        int n2 = v2.getNumPhases();
        Vector vec1Temp = this.getVector().copy().scale(p);
        Vector vec2Temp = v2.getVector().copy().scale(1.0 - p);
        res.setVector(MatrixUtils.concatVectors(vec1Temp, vec2Temp, res.getVector()));
        int[] zeroRowsLD = new int[n2];
        int[] zeroColsLD = new int[n1];
        int i = 0;
        while (i < n2) {
            zeroRowsLD[i] = n1 + i;
            ++i;
        }
        i = 0;
        while (i < n1) {
            zeroColsLD[i] = i;
            ++i;
        }
        int[] zeroRowsRU = new int[n1];
        int[] zeroColsRU = new int[n2];
        int i2 = 0;
        while (i2 < n1) {
            zeroRowsRU[i2] = i2;
            ++i2;
        }
        i2 = 0;
        while (i2 < n2) {
            zeroColsRU[i2] = n1 + i2;
            ++i2;
        }
        res.setMatrix(MatrixUtils.concatQuad(this.getMatrix(), Matrices.getSubMatrix((Matrix)res.getMatrix(), (int[])zeroRowsRU, (int[])zeroColsRU), Matrices.getSubMatrix((Matrix)res.getMatrix(), (int[])zeroRowsLD, (int[])zeroColsLD), v2.getMatrix(), res.getMatrix()));
        return res;
    }

    @Override
    public ContPhaseVar mix(double p, ContPhaseVar v2) {
        int n1 = this.getNumPhases();
        int n2 = v2.getNumPhases();
        ContPhaseVar res = this.newVar(n1 + n2);
        return this.mix(p, v2, res);
    }

    @Override
    public ContPhaseVar min(ContPhaseVar v2, ContPhaseVar res) {
        int n3;
        int n2;
        int n1 = this.getNumPhases();
        if (n1 * (n2 = v2.getNumPhases()) != (n3 = res.getNumPhases())) {
            throw new IndexOutOfBoundsException("The closure operation cannot be done:\n n1*n2 != n3(" + n1 + " * " + n2 + " != " + n3 + ")");
        }
        res.setVector(MatrixUtils.kroneckerVectors(this.getVector(), v2.getVector(), res.getVector()));
        res.setMatrix(MatrixUtils.kroneckerSum(this.getMatrix(), v2.getMatrix(), res.getMatrix()));
        return res;
    }

    @Override
    public ContPhaseVar min(ContPhaseVar v2) {
        int n1 = this.getNumPhases();
        int n2 = v2.getNumPhases();
        ContPhaseVar res = this.newVar(n1 * n2);
        return this.min(v2, res);
    }

    @Override
    public ContPhaseVar max(ContPhaseVar v2, ContPhaseVar res) {
        int n3;
        int n2;
        int n1 = this.getNumPhases();
        if (n1 * (n2 = v2.getNumPhases()) + n1 + n2 != (n3 = res.getNumPhases())) {
            throw new IndexOutOfBoundsException("The closure operation cannot be done:\n n1*n2 + n1 + n2 != n3(" + n1 + "*" + n2 + " + " + n1 + " + " + n2 + " != " + n3 + ")");
        }
        Vector vec1Temp = this.getVector().copy().scale(v2.getVec0());
        Vector vec2Temp = v2.getVector().copy().scale(this.getVec0());
        int[] zeroN1N2 = new int[n1 * n2];
        int[] zeroN1masN2 = new int[n1 + n2];
        int[] zeroN1 = new int[n1];
        int[] zeroN2 = new int[n2];
        int i = 0;
        while (i < n1 * n2) {
            zeroN1N2[i] = i;
            ++i;
        }
        i = 0;
        while (i < n1 + n2) {
            zeroN1masN2[i] = n1 * n2 + i;
            ++i;
        }
        i = 0;
        while (i < n1) {
            zeroN1[i] = n1 * n2 + i;
            ++i;
        }
        i = 0;
        while (i < n2) {
            zeroN2[i] = n1 * n2 + n1 + i;
            ++i;
        }
        res.setVector(MatrixUtils.concatVectors(MatrixUtils.kroneckerVectors(this.getVector(), v2.getVector(), Matrices.getSubVector((Vector)res.getVector(), (int[])zeroN1N2)), MatrixUtils.concatVectors(vec1Temp, vec2Temp, Matrices.getSubVector((Vector)res.getVector(), (int[])zeroN1masN2)), res.getVector()));
        Matrix sumAB = MatrixUtils.kroneckerSum(this.getMatrix(), v2.getMatrix(), Matrices.getSubMatrix((Matrix)res.getMatrix(), (int[])zeroN1N2, (int[])zeroN1N2));
        Matrix A00B = MatrixUtils.concatQuad(this.getMatrix(), Matrices.getSubMatrix((Matrix)res.getMatrix(), (int[])zeroN1, (int[])zeroN2).copy().zero(), Matrices.getSubMatrix((Matrix)res.getMatrix(), (int[])zeroN2, (int[])zeroN1), v2.getMatrix(), Matrices.getSubMatrix((Matrix)res.getMatrix(), (int[])zeroN1masN2, (int[])zeroN1masN2));
        Matrix matRU = MatrixUtils.concatCols(MatrixUtils.kronecker((Matrix)Matrices.identity((int)n1), v2.getMat0(), Matrices.getSubMatrix((Matrix)res.getMatrix(), (int[])zeroN1N2, (int[])zeroN1)), MatrixUtils.kronecker(this.getMat0(), (Matrix)Matrices.identity((int)n2), Matrices.getSubMatrix((Matrix)res.getMatrix(), (int[])zeroN1N2, (int[])zeroN2)), Matrices.getSubMatrix((Matrix)res.getMatrix(), (int[])zeroN1N2, (int[])zeroN1masN2));
        res.setMatrix(MatrixUtils.concatQuad(sumAB, matRU, Matrices.getSubMatrix((Matrix)res.getMatrix(), (int[])zeroN1masN2, (int[])zeroN1N2).copy().zero(), A00B, res.getMatrix()));
        return res;
    }

    @Override
    public ContPhaseVar max(ContPhaseVar v2) {
        int n1 = this.getNumPhases();
        int n2 = v2.getNumPhases();
        ContPhaseVar res = this.newVar(n1 + n2 + n1 * n2);
        return this.max(v2, res);
    }

    @Override
    public ContPhaseVar times(double c) {
        ContPhaseVar res = this.copy();
        res.setVector(this.getVector());
        res.setMatrix(this.getMatrix());
        res.getMatrix().scale(1.0 / c);
        return res;
    }

    @Override
    public ContPhaseVar residualTime(double x) {
        ContPhaseVar res = this.copy();
        double denom = this.survival(x);
        Vector vecTemp = this.getVector().copy().scale(1.0 / denom);
        res.setVector(MatrixUtils.exp(this.getMatrix(), x).transMult(vecTemp, res.getVector()));
        res.setMatrix(this.getMatrix());
        return res;
    }

    @Override
    public ContPhaseVar eqResidualTime() {
        ContPhaseVar res = this.copy();
        double mu = this.expectedValue();
        Vector pi = this.getVector().copy().zero();
        CG solv = new CG(pi);
        Matrix A1 = this.getMatrix().copy().transpose();
        Matrix A = A1.copy();
        A = A1.transAmult(A1, A);
        Vector b = A1.transMult(this.getVector(), this.getVector().copy());
        try {
            solv.solve(A, b, pi);
        }
        catch (IterativeSolverNotConvergedException e) {
            e.printStackTrace();
        }
        res.setVector(pi.scale(-1.0 / mu));
        res.setMatrix(this.getMatrix());
        return res;
    }

    @Override
    public ContPhaseVar waitingQ(double rho) {
        ContPhaseVar res = this.copy();
        if (rho >= 1.0) {
            throw new IllegalArgumentException("rho (" + rho + ") >= 1\n" + "non-stable queue");
        }
        double mu = this.expectedValue();
        Vector pi = this.getVector().copy().zero();
        CG solv = new CG(pi);
        Matrix At = this.getMatrix().copy().transpose();
        Matrix A = At.copy();
        A = At.transAmult(At, A);
        Vector b = At.transMult(this.getVector(), this.getVector().copy());
        try {
            solv.solve(A, b, pi);
        }
        catch (IterativeSolverNotConvergedException e) {
            e.printStackTrace();
        }
        res.setVector(pi.scale(-rho / mu));
        res.setMatrix(this.getMatrix().copy().add(MatrixUtils.multVector(this.getMat0(), res.getVector(), res.getMatrix().copy())));
        return res;
    }

    @Override
    public ContPhaseVar residualVar(double a) {
        ContPhaseVar res = this.copy();
        res.setVector(MatrixUtils.exp(this.getMatrix(), a).transMult(this.getVector(), this.getVector().copy()));
        res.setMatrix(this.getMatrix());
        return res;
    }

    @Override
    public final String toString() {
        return this.description();
    }

    @Override
    public String label() {
        return "CPH - " + this.getNumPhases() + " Phases";
    }

    @Override
    public String description() {
        String s = "__________________________________________________\n";
        s = String.valueOf(s) + "Phase-Type Distribution";
        s = String.valueOf(s) + "\nNumber of Phases: " + this.getNumPhases() + "\n";
        s = String.valueOf(s) + "Vector:\n\t";
        int i = 0;
        while (i < this.getNumPhases()) {
            s = String.valueOf(s) + String.format("%6.4f", this.getVector().get(i));
            s = String.valueOf(s) + "\t";
            ++i;
        }
        s = String.valueOf(s) + "\nMatrix:\n";
        i = 0;
        while (i < this.getNumPhases()) {
            s = String.valueOf(s) + "\t";
            int j = 0;
            while (j < this.getNumPhases()) {
                s = String.valueOf(s) + String.format("%6.4f", this.getMatrix().get(i, j));
                s = String.valueOf(s) + "\t";
                ++j;
            }
            s = String.valueOf(s) + "\n";
            ++i;
        }
        s = String.valueOf(s) + "__________________________________________________\n";
        return s;
    }
}

