/*
 * Decompiled with CFR 0.152.
 */
package jmdp;

import examples.jmdp.ControlProdNonEvents;
import examples.jmdp.InvLevel;
import examples.jmdp.Order;
import jmarkov.Utils;
import jmarkov.jmdp.solvers.MPSQsOptAverageSolver;
import jmarkov.jmdp.solvers.MPSQsOptDiscountedSolver;
import jmarkov.jmdp.solvers.PolicyIterationSolver;
import jmarkov.jmdp.solvers.PolicyIterationSolverAvg;
import jmarkov.jmdp.solvers.RelativeValueIterationSolver;
import jmarkov.jmdp.solvers.Solver;
import jmarkov.jmdp.solvers.ValueIterationSolver;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class SolversTest
extends TestCase {
    String workingDir = "src\\examples\\jmdp\\MPSFolder";
    ControlProdNonEvents prob = null;
    Solver solver;
    double disFactor = 0.9;
    double intRate = 1.0 / this.disFactor - 1.0;
    double[] discOpt = new double[]{-13644.2762, -13964.2762, -14284.2762, -14795.2222, -15424.2762};
    double[] avgOpt = new double[]{-1390.6495, -1390.6495, -1390.6495, -1390.6495, -1390.6495};
    int[] actOpt;

    public SolversTest() {
        int[] nArray = new int[5];
        nArray[0] = 4;
        nArray[1] = 3;
        nArray[2] = 2;
        this.actOpt = nArray;
    }

    protected void setUp() throws Exception {
        super.setUp();
        int M = 4;
        double K = 500.0;
        double cost = 400.0;
        double price = 1000.0;
        double holdingCost = 80.0;
        double demandMean = 4.0;
        this.prob = new ControlProdNonEvents(M, K, cost, price, holdingCost, this.intRate, demandMean);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.prob = null;
        System.gc();
    }

    public void testValueIteration() throws Exception {
        this.solver = new ValueIterationSolver<InvLevel, Order>(this.prob, this.intRate);
        this.prob.getSolver().setPrintValueFunction(true);
        double[] vf = this.prob.getOptimalValueFunction().get();
        Utils.assertArrayEquals("Value Function not equal", this.discOpt, vf, 0.001);
        int[] ord = this.prob.getOptimalOrderSize();
        Utils.assertArrayEquals("Value Function not equal", this.actOpt, ord);
    }

    public void testPolicyIteration() throws Exception {
        this.solver = new PolicyIterationSolver<InvLevel, Order>(this.prob, this.intRate);
        this.prob.setSolver(this.solver);
        this.prob.getSolver().setPrintValueFunction(true);
        double[] vf = this.prob.getOptimalValueFunction().get();
        Utils.assertArrayEquals("Value Function not equal", this.discOpt, vf, 0.001);
        int[] ord = this.prob.getOptimalOrderSize();
        Utils.assertArrayEquals("Value Function not equal", this.actOpt, ord);
    }

    public void testModifiedPolicyIteration() throws Exception {
        PolicyIterationSolver<InvLevel, Order> solver = new PolicyIterationSolver<InvLevel, Order>(this.prob, this.intRate);
        this.prob.setSolver(solver);
        solver.setModifiedPolicy(true);
        this.prob.getSolver().setPrintValueFunction(true);
        double[] vf = this.prob.getOptimalValueFunction().get();
        Utils.assertArrayEquals("Value Function not equal", this.discOpt, vf, 0.001);
        int[] ord = this.prob.getOptimalOrderSize();
        Utils.assertArrayEquals("Value Function not equal", this.actOpt, ord);
    }

    public void testRelativeValueIterSolver() throws Exception {
        this.solver = new RelativeValueIterationSolver<InvLevel, Order>(this.prob);
        this.prob.setSolver(this.solver);
        this.prob.getSolver().setPrintValueFunction(true);
        double[] vf = this.prob.getOptimalValueFunction().get();
        Utils.assertArrayEquals("Value Function not equal", this.avgOpt, vf, 0.001);
        int[] ord = this.prob.getOptimalOrderSize();
        Utils.assertArrayEquals("Value Function not equal", this.actOpt, ord);
    }

    public void testPolicyIterationSolverAvg() throws Exception {
        PolicyIterationSolverAvg<InvLevel, Order> solver = new PolicyIterationSolverAvg<InvLevel, Order>(this.prob);
        this.prob.setSolver(solver);
        this.prob.getSolver().setPrintValueFunction(true);
        double[] vf = this.prob.getOptimalValueFunction().get();
        int[] ord = this.prob.getOptimalOrderSize();
        Utils.assertEquals((String)"Value Function not equal", (double)this.avgOpt[0], (double)vf[0], (double)0.01);
        Utils.assertArrayEquals("Value Function not equal", this.actOpt, ord);
    }

    public void testMPSQsDiscounted() throws Exception {
        this.solver = new MPSQsOptDiscountedSolver<InvLevel, Order>(this.prob, this.intRate, this.workingDir, "MDPQsDisc.mps");
        this.prob.setSolver(this.solver);
        this.prob.getSolver().setPrintValueFunction(true);
        double[] vf = this.prob.getOptimalValueFunction().get();
        Utils.assertArrayEquals("Value Function not equal", this.discOpt, vf, 0.01);
        int[] ord = this.prob.getOptimalOrderSize();
        Utils.assertArrayEquals("Value Function not equal", this.actOpt, ord);
    }

    public void testMPSQsAverage() throws Exception {
        this.solver = new MPSQsOptAverageSolver<InvLevel, Order>(this.prob, this.workingDir, "MDPQsAvg.mps");
        this.prob.setSolver(this.solver);
        this.prob.getSolver().setPrintValueFunction(true);
        double[] vf = this.prob.getOptimalValueFunction().get();
        Utils.assertArrayEquals("Value Function not equal", this.avgOpt, vf, 0.01);
        int[] ord = this.prob.getOptimalOrderSize();
        Utils.assertArrayEquals("Value Function not equal", this.actOpt, ord);
    }

    public static void main(String[] args) {
        TestRunner.run(SolversTest.class);
    }
}

