/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.solvers;

import jmarkov.MarkovProcess;
import jmarkov.basic.exceptions.NotUnichainException;
import jmarkov.solvers.SteadyStateSolver;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.BiCG;
import no.uib.cipr.matrix.sparse.BiCGstab;
import no.uib.cipr.matrix.sparse.CGS;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.DefaultIterationMonitor;
import no.uib.cipr.matrix.sparse.DiagonalPreconditioner;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import no.uib.cipr.matrix.sparse.GMRES;
import no.uib.cipr.matrix.sparse.ILU;
import no.uib.cipr.matrix.sparse.IterationMonitor;
import no.uib.cipr.matrix.sparse.IterativeSolver;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.QMR;
import no.uib.cipr.matrix.sparse.SSOR;
import no.uib.cipr.matrix.sparse.SparseVector;

public class MtjSolver
extends SteadyStateSolver {
    private long processTime = -1L;
    private EnumPrecond currentPreConditioner = EnumPrecond.IDEN;
    private EnumSolver currentIterSolver = EnumSolver.BiCGstab;
    private IterativeSolver iterativeSolver = null;
    private Preconditioner preConditioner = null;
    private boolean tryOthers = true;
    private Matrix A;
    private Vector b;
    private Vector pi0;
    private double maxLambda = 0.0;
    private Matrix genMatrix = null;

    public MtjSolver(MarkovProcess mp) {
        this(mp, EnumSolver.BiCGstab, true);
    }

    public MtjSolver(MarkovProcess mp, EnumSolver solver) {
        this(mp, solver, false);
    }

    public MtjSolver(MarkovProcess mp, EnumSolver solver, boolean tryOthers) {
        super(mp);
        this.currentIterSolver = solver;
        this.tryOthers = tryOthers;
    }

    public Matrix getGenerator() {
        if (this.genMatrix != null) {
            return this.genMatrix;
        }
        this.mp.debug(1, "Building MTJ Generator Matrix ...");
        FlexCompRowMatrix R = new FlexCompRowMatrix(this.mp.getMtjRates());
        int n = R.numRows();
        double[] sum = new double[n];
        Matrix Q = R.copy();
        for (MatrixEntry e : Q) {
            int j;
            int i = e.row();
            if (i == (j = e.column())) continue;
            int n2 = i;
            sum[n2] = sum[n2] + R.get(i, j);
        }
        int i = 0;
        while (i < n) {
            Q.set(i, i, -sum[i]);
            this.maxLambda = Math.max(sum[i], this.maxLambda);
            ++i;
        }
        this.mp.debug(3, "The Generator matrix is: \n" + Q);
        this.genMatrix = Q;
        return this.genMatrix;
    }

    private Matrix getSystemMatrix() {
        if (this.A == null) {
            Matrix Q = this.getGenerator();
            this.A = Q.copy();
            int n = this.A.numRows();
            int i = 0;
            while (i < n) {
                this.A.set(i, n - 1, 1.0);
                ++i;
            }
            this.mp.debug(4, "The A system matrix is: \n" + Q);
        }
        return this.A;
    }

    private Vector getRightVector() {
        if (this.b == null) {
            int n = this.mp.getNumStates();
            this.b = new SparseVector(n, 1);
            this.b.set(n - 1, 1.0);
            this.mp.debug(4, "The b vector is: \n" + this.b);
        }
        return this.b;
    }

    private Vector getInitialVector() {
        int n = this.mp.getNumStates();
        if (this.pi0 == null) {
            this.pi0 = new DenseVector(n);
            double pr = 1.0 / (double)n;
            int i = 0;
            while (i < n) {
                this.pi0.set(i, pr);
                ++i;
            }
        }
        return this.pi0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double[] getSteadyState() throws NotUnichainException {
        block8: {
            block9: {
                this.mp.debug(1, "Computing  Steady State Probabilities with solver " + this + " ...");
                this.A = this.getSystemMatrix();
                this.b = this.getRightVector();
                this.pi0 = this.getInitialVector();
                this.mp.debug(4, "Solving: pi A = b ..." + this.b);
                pi = null;
                try {
                    pi = this.solve(this.A, this.b, this.pi0, this.currentIterSolver);
                    break block8;
                }
                catch (IterativeSolverNotConvergedException e) {
                    if (!this.tryOthers) break block9;
                    this.mp.debug(1, "Solver " + (Object)this.currentIterSolver + " failed ...");
                    var6_3 = EnumSolver.values();
                    var5_4 = var6_3.length;
                    var4_5 = 0;
                    ** while (var4_5 < var5_4)
                }
lbl-1000:
                // 1 sources

                {
                    solv = var6_3[var4_5];
                    if (solv != this.currentIterSolver) {
                        this.mp.debug(1, "Trying solver " + (Object)solv + "...");
                        try {
                            pi = this.solve(this.A, this.b, this.pi0, solv);
                        }
                        catch (IterativeSolverNotConvergedException e2) {
                            pi = null;
                        }
                        if (pi != null) {
                            return pi.getData();
                        }
                    }
                    ++var4_5;
                    continue;
                }
            }
            if (pi == null) {
                throw new NotUnichainException("Exception solving Steady State probabilitis with solver " + this + "\n(Reason :" + e.getReason() + ", Iterations: " + e.getIterations() + ")");
            }
        }
        return pi.getData();
    }

    private DenseVector solve(Matrix A, Vector b, Vector pi0, EnumSolver iterSolver) throws IterativeSolverNotConvergedException {
        this.iterativeSolver = this.getIterativeSolver(pi0, iterSolver);
        this.preConditioner = this.getPreConditioner(A);
        DenseVector sol = null;
        if (this.currentPreConditioner != EnumPrecond.IDEN) {
            this.iterativeSolver.setPreconditioner(this.preConditioner);
        }
        long initialTime = System.currentTimeMillis();
        sol = new DenseVector(this.iterativeSolver.solve(A.transpose(), b, pi0), false);
        this.processTime = System.currentTimeMillis() - initialTime;
        this.mp.debug(1, "Solve time : " + this.processTime + " milliseconds.");
        return sol;
    }

    @Override
    public String label() {
        return "MTJ Solver: PreCond =  " + (Object)((Object)this.currentPreConditioner) + " Iter Solver = " + (Object)((Object)this.currentIterSolver);
    }

    public EnumSolver getCurrentIterSolver() {
        return this.currentIterSolver;
    }

    public void setIterSolver(EnumSolver iterSolver, boolean tryOthers) {
        this.currentIterSolver = iterSolver;
        this.tryOthers = tryOthers;
        this.mp.resetResults();
    }

    public void setCurrentIterSolver(EnumSolver iterSolver) {
        this.setIterSolver(iterSolver, false);
    }

    public EnumPrecond getCurrentPreConditioner() {
        return this.currentPreConditioner;
    }

    public void setCurrentPreConditioner(EnumPrecond preConditioner) {
        this.currentPreConditioner = preConditioner;
        this.mp.resetResults();
    }

    public final boolean isTryOthers() {
        return this.tryOthers;
    }

    public final void setTryOthers(boolean tryOthers) {
        this.tryOthers = tryOthers;
    }

    public final Matrix getGenMatrix() {
        return this.genMatrix;
    }

    public final long getProcessTime() {
        return this.processTime;
    }

    public IterativeSolver getIteartiveSolver(Vector pi) {
        return this.getIterativeSolver(pi, this.currentIterSolver);
    }

    public IterativeSolver getIterativeSolver(Vector pi0, EnumSolver solver) {
        if (this.iterativeSolver == null) {
            switch (solver) {
                case BiCG: {
                    this.iterativeSolver = new BiCG(pi0);
                    break;
                }
                case BiCGstab: {
                    this.iterativeSolver = new BiCGstab(pi0);
                    break;
                }
                case CGS: {
                    this.iterativeSolver = new CGS(pi0);
                    break;
                }
                case GMRES: {
                    this.iterativeSolver = new GMRES(pi0);
                    break;
                }
                case QMR: {
                    this.iterativeSolver = new QMR(pi0);
                }
            }
            DefaultIterationMonitor mon = new DefaultIterationMonitor(100000, 1.0E-6, 1.0E-50, 100000.0);
            this.iterativeSolver.setIterationMonitor((IterationMonitor)mon);
        }
        return this.iterativeSolver;
    }

    private Preconditioner getPreConditioner(Matrix A) {
        if (this.preConditioner == null) {
            switch (this.currentPreConditioner) {
                case IDEN: {
                    this.preConditioner = null;
                    break;
                }
                case SSOR: {
                    this.preConditioner = new SSOR((CompRowMatrix)A);
                    break;
                }
                case DIA: {
                    this.preConditioner = new DiagonalPreconditioner(A.numRows());
                    break;
                }
                case ILU: {
                    this.preConditioner = new ILU((CompRowMatrix)A);
                }
            }
        }
        return this.preConditioner;
    }

    @Override
    public String description() {
        return "This Solvers use the methods implemented in MTJ";
    }

    public static enum EnumPrecond {
        IDEN("IdentityPreconditioner"),
        SSOR("SuccessiveOverrelaxation"),
        DIA("DiagonalPreconditioner"),
        ILU("ILU");

        private String name = "";

        private EnumPrecond(String name) {
            this.name = name;
        }

        public String label() {
            return this.name;
        }
    }

    public static enum EnumSolver {
        BiCG("BiConjugateGradients"),
        BiCGstab("BiConjugateGradientsStabilized"),
        CGS("ConjugateGradientsSquared"),
        GMRES("GeneralizedMinimalResiduals"),
        QMR("QuasiMinimalResiduals");

        private String name = "";

        private EnumSolver() {
        }

        private EnumSolver(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

