/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.solvers;

import Jama.Matrix;
import jmarkov.MarkovProcess;
import jmarkov.basic.State;
import jmarkov.solvers.TransientSolver;
import jphase.MarkovMatrix;

public class JamaTransientSolver
extends TransientSolver {
    private Matrix alpha = null;
    private State lasti0 = null;

    public JamaTransientSolver(MarkovProcess mp) {
        super(mp);
    }

    @Override
    public String label() {
        return "Jama Transient";
    }

    private Matrix getInitialConditions(State i0, int n) {
        if (i0 == this.lasti0) {
            return this.alpha;
        }
        Matrix result = new Matrix(1, n);
        result.set(0, i0.getIndex(), 1.0);
        this.alpha = result;
        return result;
    }

    @Override
    public double[] getTransientProbs(double time, State i0) {
        return this.getTransientProbs(new double[]{time}, i0)[0];
    }

    @Override
    public double[][] getTransientProbs(double[] times, State i0) {
        MarkovMatrix Q = new MarkovMatrix(this.mp.getGenerator());
        int n = Q.size();
        Matrix alpha = this.getInitialConditions(i0, n);
        Matrix I = Matrix.identity((int)n, (int)n);
        int numTimes = times.length;
        double[][] results = new double[numTimes][];
        MarkovMatrix[] matrixResult = Q.expUnif(times, alpha, I);
        int t = 0;
        while (t < numTimes) {
            results[t] = matrixResult[t].getRowPackedCopy();
            ++t;
        }
        return results;
    }

    @Override
    public double[][] getTransientProbs(int NumberPoints, double delta, State i0) {
        double[] times = new double[NumberPoints];
        int t = 0;
        while (t < NumberPoints) {
            times[t] = delta * (double)t;
            ++t;
        }
        return this.getTransientProbs(times, i0);
    }

    @Override
    public String description() {
        return "Transient state solver using JAMA";
    }
}

