/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jqbd.solvers;

import java.util.ArrayList;
import jphase.MatrixUtils;
import jphase.PhaseVar;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

public abstract class QBDPhaseSolver {
    protected DenseMatrix R;
    protected Matrix MA0;
    protected Matrix MA1;
    protected Matrix MA2;
    protected Matrix MB0;
    protected Matrix MB1;
    protected Matrix MB2;
    protected DenseMatrix N;
    protected DenseMatrix U;
    protected DenseMatrix G;
    protected ArrayList<Double> pis;
    protected ArrayList<DenseMatrix> pisP;
    protected PhaseVar arr;
    protected PhaseVar serv;
    private double lambdaP;

    public void initilicePHPH1(PhaseVar arrivals, PhaseVar service) {
        this.arr = arrivals;
        this.serv = service;
        Vector alpha = arrivals.getVector();
        Vector beta = service.getVector();
        Matrix A = arrivals.getMatrix();
        Matrix M = service.getMatrix();
        int tamA = A.numRows();
        int tamM = M.numRows();
        double[] era = new double[tamA];
        double[] erm = new double[tamM];
        int i = 0;
        while (i != tamA) {
            era[i] = 1.0;
            ++i;
        }
        i = 0;
        while (i != tamM) {
            erm[i] = 1.0;
            ++i;
        }
        DenseVector lambda = QBDPhaseSolver.negativeMatVecMult(A, era, new DenseVector(tamA));
        DenseVector muV = QBDPhaseSolver.negativeMatVecMult(M, erm, new DenseVector(tamM));
        DenseMatrix IA = new DenseMatrix((Matrix)Matrices.identity((int)tamA));
        DenseMatrix IM = new DenseMatrix((Matrix)Matrices.identity((int)tamM));
        this.MA0 = new DenseMatrix(tamA * tamM, tamA * tamM);
        this.MA2 = new DenseMatrix(tamA * tamM, tamA * tamM);
        this.MB0 = new DenseMatrix(tamA, tamA * tamM);
        this.MB2 = new DenseMatrix(tamA * tamM, tamA);
        this.MA0 = MatrixUtils.kronecker(QBDPhaseSolver.multVector(lambda, new DenseVector(alpha), new DenseMatrix(lambda.size(), alpha.size())), (Matrix)IM, this.MA0);
        this.MA1 = MatrixUtils.kroneckerSum(A, M);
        this.MA2 = MatrixUtils.kronecker((Matrix)IA, QBDPhaseSolver.multVector(muV, new DenseVector(beta), new DenseMatrix(muV.size(), beta.size())), this.MA2);
        this.MB0 = MatrixUtils.kronecker(QBDPhaseSolver.multVector(lambda, new DenseVector(alpha), new DenseMatrix(lambda.size(), alpha.size())), (Matrix)QBDPhaseSolver.rowVectoraMat(new DenseVector(beta)), this.MB0);
        this.MB1 = A.copy();
        this.MB2 = MatrixUtils.kronecker((Matrix)IA, (Vector)muV, this.MB2);
    }

    public String performanceMeasures(double[][] R1) {
        this.pis = new ArrayList();
        this.pisP = new ArrayList();
        this.R = new DenseMatrix(R1);
        DenseMatrix BON = new DenseMatrix(this.MB0.numRows(), this.N.numColumns());
        DenseMatrix BAL = new DenseMatrix(this.MB1.numRows(), this.MB1.numColumns());
        DenseMatrix NORM = new DenseMatrix(this.MB0.numRows(), 1);
        DenseMatrix I = new DenseMatrix((Matrix)Matrices.identity((int)this.R.numColumns()));
        this.MB0.mult((Matrix)this.N, (Matrix)BON);
        BON.mult(this.MB2, (Matrix)BAL);
        BAL.add(this.MB1);
        double[][] ones2 = new double[this.R.numRows()][1];
        int i = 0;
        while (i < this.R.numRows()) {
            ones2[i][0] = 1.0;
            ++i;
        }
        DenseMatrix oneR = new DenseMatrix(ones2);
        double[][] ones1 = new double[this.MB0.numRows()][1];
        int i2 = 0;
        while (i2 < this.MB0.numRows()) {
            ones1[i2][0] = 1.0;
            ++i2;
        }
        DenseMatrix oneB = new DenseMatrix(ones1);
        DenseMatrix IR = new DenseMatrix(this.R.copy().scale(-1.0));
        DenseMatrix IR1 = new DenseMatrix(this.R.numRows(), 1);
        IR.add((Matrix)I);
        IR.copy().solve((Matrix)I, (Matrix)IR);
        IR.mult((Matrix)oneR, (Matrix)IR1);
        BON.mult((Matrix)IR1, (Matrix)NORM);
        NORM.add((Matrix)oneB);
        DenseMatrix P3T = new DenseMatrix(NORM.numColumns(), NORM.numRows());
        DenseMatrix P2T = new DenseMatrix(BAL.numColumns(), BAL.numRows());
        BAL.copy().transpose((Matrix)P2T);
        NORM.copy().transpose((Matrix)P3T);
        double[][] A = new double[P2T.numRows()][P3T.numColumns()];
        int i3 = 0;
        while (i3 != P2T.numRows()) {
            int j = 0;
            while (j != P3T.numColumns()) {
                A[i3][j] = i3 != P2T.numRows() - 1 ? P2T.get(i3, j) : P3T.get(0, j);
                ++j;
            }
            ++i3;
        }
        DenseMatrix MF = new DenseMatrix(A);
        DenseMatrix IF = new DenseMatrix((Matrix)Matrices.identity((int)MF.numRows()));
        MF.copy().solve((Matrix)IF, (Matrix)MF);
        double[][] oones = new double[MF.numColumns()][1];
        int i4 = 0;
        while (i4 < MF.numColumns()) {
            oones[i4][0] = i4 == MF.numColumns() - 1 ? 1.0 : 0.0;
            ++i4;
        }
        DenseMatrix oone = new DenseMatrix(oones);
        DenseMatrix PI0T = new DenseMatrix(MF.numColumns(), 1);
        MF.mult((Matrix)oone, (Matrix)PI0T);
        DenseMatrix pi0 = new DenseMatrix(1, MF.numColumns());
        PI0T.transpose((Matrix)pi0);
        DenseMatrix pi1 = new DenseMatrix(1, BON.numColumns());
        pi0.copy().mult((Matrix)BON.copy(), (Matrix)pi1);
        double sum = 0.0;
        double Lq = 0.0;
        double piCero = 0.0;
        double pi = 0.0;
        int i5 = 0;
        while (i5 != pi0.numColumns()) {
            pi += pi0.get(0, i5);
            ++i5;
        }
        piCero = pi;
        sum += pi;
        this.pis.add(pi);
        this.pisP.add(pi0);
        pi = 0.0;
        i5 = 0;
        while (i5 != pi1.numColumns()) {
            pi += pi1.get(0, i5);
            ++i5;
        }
        sum += pi;
        this.pis.add(pi);
        this.pisP.add(pi1);
        DenseMatrix pin = pi1.copy();
        int i6 = 1;
        while (1.0 - sum > 1.0E-8) {
            DenseMatrix piN = new DenseMatrix(1, this.R.numColumns());
            pin.copy().mult((Matrix)this.R.copy(), (Matrix)piN);
            pi = 0.0;
            int j = 0;
            while (j != pi1.numColumns()) {
                pi += piN.get(0, j);
                ++j;
            }
            pin = piN.copy();
            sum += pi;
            Lq += pi * (double)i6;
            this.pis.add(pi);
            this.pisP.add(piN);
            ++i6;
        }
        double lam = this.getLambda();
        String resp = "";
        resp = String.valueOf(resp) + "WIP (Queue): " + String.format("%6.4f", Lq) + "\n";
        resp = String.valueOf(resp) + "WIP (Service): " + String.format("%6.4f", 1.0 - piCero) + "\n";
        resp = String.valueOf(resp) + "WIP (Total): " + String.format("%6.4f", Lq + 1.0 - piCero) + "\n";
        resp = String.valueOf(resp) + "____________________________________\n";
        resp = String.valueOf(resp) + "Expected time in Queue: " + String.format("%6.4f", Lq * lam) + "\n";
        resp = String.valueOf(resp) + "Expected time in service: " + String.format("%6.4f", (1.0 - piCero) * lam) + "\n";
        resp = String.valueOf(resp) + "Expected time in the system: " + String.format("%6.4f", (Lq + 1.0 - piCero) * lam) + "\n";
        resp = String.valueOf(resp) + "____________________________________\n";
        return resp;
    }

    public ArrayList<Double> getLevelSteadyStateProbs() {
        return this.pis;
    }

    public ArrayList<DenseMatrix> getSteadyStateProbsPerLevel() {
        return this.pisP;
    }

    public void printMatrices() {
        this.printVector(new DenseMatrix(this.MA0), "A0");
        this.printVector(new DenseMatrix(this.MA1), "A1");
        this.printVector(new DenseMatrix(this.MA2), "A2");
        this.printVector(new DenseMatrix(this.MB0), "B0");
        this.printVector(new DenseMatrix(this.MB1), "B1");
        this.printVector(new DenseMatrix(this.MB2), "B2");
        this.printVector(this.U, "U");
        this.printVector(this.G, "G");
        this.printVector(this.R, "R");
    }

    protected void printVector(DenseMatrix matrix, String matrixName) {
        System.out.println("Matrix: " + matrixName);
        double[][] matriz = Matrices.getArray((Matrix)matrix);
        int i = 0;
        while (i != matrix.numRows()) {
            int j = 0;
            while (j != matrix.numColumns()) {
                System.out.print(String.valueOf(matriz[i][j]) + "\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    private double getLambda() {
        if (this.lambdaP == 0.0) {
            Matrix A = this.arr.getMatrix();
            int tamA = A.numColumns();
            double[] era = new double[tamA];
            int i = 0;
            while (i != tamA) {
                era[i] = 1.0;
                ++i;
            }
            DenseMatrix AI = new DenseMatrix(tamA, tamA);
            DenseMatrix IA = new DenseMatrix((Matrix)Matrices.identity((int)tamA));
            A.solve((Matrix)IA, (Matrix)AI);
            DenseVector lambda1 = QBDPhaseSolver.negativeMatVecMult((Matrix)AI, era, new DenseVector(tamA));
            this.lambdaP = this.rowCol(new DenseVector(this.arr.getVector()), lambda1);
        }
        return this.lambdaP;
    }

    public static DenseVector negativeMatVecMult(Matrix A, double[] era, DenseVector denseVector) {
        int i = 0;
        while (i != A.numRows()) {
            double sum = 0.0;
            int j = 0;
            while (j < A.numColumns()) {
                sum += A.get(i, j) * era[j];
                ++j;
            }
            denseVector.set(i, -sum);
            ++i;
        }
        return denseVector;
    }

    private double rowCol(DenseVector fila, DenseVector colu) {
        double[] col;
        double[] row = fila.getData();
        if (row.length != (col = colu.getData()).length) {
            throw new IndexOutOfBoundsException("row.length != col.length " + row.length + " != " + col.length);
        }
        double ret = 0.0;
        int i = 0;
        while (i != row.length) {
            ret += row[i] * col[i];
            ++i;
        }
        return ret;
    }

    public static Matrix multVector(DenseVector A, DenseVector B, DenseMatrix res) {
        int n = res.numRows();
        int m = res.numColumns();
        if (A.size() != n) {
            throw new IndexOutOfBoundsException("A.size() != res.numRows() (" + A.size() + " != " + n + ")");
        }
        if (B.size() != m) {
            throw new IndexOutOfBoundsException("B.size() != res.numColumns() (" + B.size() + " != " + m + ")");
        }
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                res.set(i, j, A.get(i) * B.get(j));
                ++j;
            }
            ++i;
        }
        return res;
    }

    private static DenseMatrix rowVectoraMat(DenseVector dv) {
        double[] data = dv.getData();
        double[][] mat = new double[1][data.length];
        int i = 0;
        while (i != data.length) {
            mat[0][i] = data[i];
            ++i;
        }
        return new DenseMatrix(mat);
    }

    public boolean unstableSystem() {
        if (this.arr == null || this.serv == null) {
            return true;
        }
        return this.arr.expectedValue() <= this.serv.expectedValue();
    }

    public void setLambda(double lambda) {
        this.lambdaP = lambda;
    }

    public abstract double[][] getRmatrix();
}

