/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jqbd.solvers;

import jmarkov.jqbd.solvers.QBDPhaseSolver;
import jphase.PhaseVar;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;

public class ModBoundSolverFromMatrix
extends QBDPhaseSolver {
    public ModBoundSolverFromMatrix(PhaseVar arrivals, PhaseVar service) {
        this.initilicePHPH1(arrivals, service);
    }

    @Override
    public double[][] getRmatrix() {
        double epsilon = 1.0E-108;
        int dimen = this.MA1.numRows();
        DenseMatrix I = new DenseMatrix((Matrix)Matrices.identity((int)dimen));
        DenseMatrix INV = new DenseMatrix(dimen, dimen);
        DenseMatrix sum = new DenseMatrix(I.copy());
        sum.add(this.MA0.copy().scale(-1.0));
        sum.add(this.MA1.copy().scale(-1.0));
        sum.solve((Matrix)I, (Matrix)INV);
        this.G = new DenseMatrix(dimen, dimen);
        DenseMatrix Gold = new DenseMatrix(dimen, dimen);
        this.U = new DenseMatrix(dimen, dimen);
        INV.mult(this.MA2, (Matrix)this.G);
        double compare = 1.0;
        while (compare > epsilon) {
            Gold = this.G.copy();
            this.MA0.mult((Matrix)this.G, (Matrix)this.U);
            this.U.add(this.MA1);
            sum = this.U.copy().scale(-1.0);
            sum.solve((Matrix)I, (Matrix)INV);
            INV.mult(this.MA2, (Matrix)this.G);
            Gold.add(this.G.copy().scale(-1.0));
            compare = Math.abs(Gold.get(0, 0));
            int i = 0;
            while (i < Gold.numRows()) {
                int j = 0;
                while (j < Gold.numColumns()) {
                    compare = Math.max(compare, Math.abs(Gold.get(i, j)));
                    ++j;
                }
                ++i;
            }
            System.out.println("Compare: " + compare);
        }
        this.U = new DenseMatrix(dimen, dimen);
        this.N = new DenseMatrix(dimen, dimen);
        this.R = new DenseMatrix(dimen, dimen);
        this.U = (DenseMatrix)this.MA0.multAdd((Matrix)this.G, this.MA1.copy());
        DenseMatrix mA1I = new DenseMatrix(dimen, dimen);
        DenseMatrix UA = new DenseMatrix(dimen, dimen);
        this.U.mult(-1.0, (Matrix)I, (Matrix)UA);
        UA.solve((Matrix)I, (Matrix)mA1I);
        this.N.set((Matrix)mA1I);
        this.MA0.mult((Matrix)mA1I, (Matrix)this.R);
        return Matrices.getArray((Matrix)this.R);
    }

    public String label() {
        return "Modified boundary solver. This solver uses the MTJ package to handle matrices from a phase ditribution.";
    }
}

