/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp.solvers;

import jmarkov.basic.Action;
import jmarkov.basic.Solution;
import jmarkov.basic.State;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.CT2DTConverter;
import jmarkov.jmdp.CTMDP;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.solvers.MPSQsOptDiscountedSolver;
import jmarkov.jmdp.solvers.MpsLpAverageSolver;

public class MPSQsOptAverageSolver<S extends State, A extends Action>
extends MpsLpAverageSolver<S, A> {
    private MPSQsOptDiscountedSolver<S, A> discSolver = null;

    public MPSQsOptAverageSolver(DTMDP<S, A> problem) {
        super(problem);
        this.discSolver = new MPSQsOptDiscountedSolver<S, A>(problem, 0.0, true);
    }

    public MPSQsOptAverageSolver(DTMDP<S, A> problem, String workingDir, String fileName) {
        super(problem, workingDir, fileName);
        this.discSolver = new MPSQsOptDiscountedSolver<S, A>(problem, 0.0, workingDir, fileName, true);
    }

    public MPSQsOptAverageSolver(CTMDP<S, A> problem) {
        super(new CT2DTConverter<S, A>(problem));
        this.discSolver = new MPSQsOptDiscountedSolver<S, A>(problem, 0.0, true);
    }

    public MPSQsOptAverageSolver(CTMDP<S, A> problem, String workingDir, String fileName) {
        super(new CT2DTConverter<S, A>(problem), workingDir, fileName);
        this.discSolver = new MPSQsOptDiscountedSolver<S, A>(problem, 0.0, workingDir, fileName, true);
    }

    @Override
    public String label() {
        return "QsOpt Solver (AVG Cost)";
    }

    @Override
    public void solveLP() throws SolverException {
        this.discSolver.solveLP();
    }

    @Override
    public Solution<S, A> buildSolution() throws SolverException {
        return this.discSolver.buildSolution();
    }
}

