/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp.solvers;

import com.dashoptimization.XPRBctr;
import com.dashoptimization.XPRBlinExp;
import com.dashoptimization.XPRBprob;
import com.dashoptimization.XPRBvar;
import java.util.Iterator;
import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.DecisionRule;
import jmarkov.basic.Policy;
import jmarkov.basic.Solution;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.ValueFunction;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.InfiniteMDP;
import jmarkov.jmdp.solvers.AbstractDiscountedSolver;
import jmarkov.jmdp.solvers.LPSolver;

public class LPBCLDiscountedSolver<S extends State, A extends Action>
extends AbstractDiscountedSolver<S, A>
implements LPSolver {
    private long processTime = -1L;
    private long buildTime = -1L;
    private long lpSolveTime = -1L;
    private long solBuildTime = -1L;
    private boolean isAvg = false;
    private boolean showXpressOutput = false;
    private XPRBprob linearProblem = null;
    private int solveResult;

    public LPBCLDiscountedSolver(DTMDP<S, A> problem, double interestRate) {
        super(problem, interestRate);
    }

    LPBCLDiscountedSolver(DTMDP<S, A> problem) {
        this(problem, 0.0);
        this.isAvg = true;
    }

    @Override
    public long getIterations() {
        return 0L;
    }

    @Override
    public Solution<S, A> solve() throws SolverException {
        long startTime = System.currentTimeMillis();
        try {
            this.linearProblem = new XPRBprob();
            if (!this.showXpressOutput) {
                this.linearProblem.setMsgLevel(0);
            }
            this.createObjectiveFunctionAndConstraints(this.linearProblem);
            long endBuild = System.currentTimeMillis();
            this.buildTime = endBuild - startTime;
            this.solveLP();
            long endLP = System.currentTimeMillis();
            this.lpSolveTime = endLP - endBuild;
            if (this.solveResult != 0) {
                throw new SolverException("Xpress failed to solve the problem");
            }
            this.buildSolution();
            this.solBuildTime = System.currentTimeMillis() - endLP;
            this.processTime = System.currentTimeMillis() - startTime;
            return new Solution(this.valueFunction, this.policy);
        }
        catch (UnsatisfiedLinkError e) {
            throw new SolverException("This solver requires XPess professional edition.", e);
        }
        catch (NoClassDefFoundError e) {
            throw new SolverException("This solver requires XPess professional edition.", e);
        }
    }

    private void createObjectiveFunctionAndConstraints(XPRBprob linearProblem) {
        XPRBlinExp objectiveFunction = new XPRBlinExp();
        XPRBctr constraintNorm = null;
        StatesSet<State> statesI = this.getDiscreteProblem().getAllStates();
        double alpha = (this.isAvg ? 0.0 : 1.0) / (double)this.getDiscreteProblem().getAllStates().size();
        int indexVariables = 0;
        int n = this.getDiscreteProblem().getNumStates();
        int indexStates = 0;
        while (indexStates < n) {
            XPRBctr constraint = linearProblem.newCtr(String.valueOf(indexStates));
            constraint.add(alpha);
            constraint.setType(3);
            ++indexStates;
        }
        if (this.isAvg) {
            constraintNorm = linearProblem.newCtr("NORM");
            constraintNorm.setType(3);
            constraintNorm.add(1.0);
        }
        for (State stateI : statesI) {
            Actions actions = ((InfiniteMDP)this.getProblem()).feasibleActions(stateI);
            for (Action action : actions) {
                double cost = this.getDiscreteProblem().immediateCost(stateI, action);
                String variableName = String.valueOf(indexVariables);
                XPRBvar variable = linearProblem.newVar(variableName, 0, 0.0, Double.MAX_VALUE);
                objectiveFunction.add(variable.mul(cost));
                States<State> statesJ = this.getDiscreteProblem().reachable(stateI, action);
                for (State stateJ : statesJ) {
                    double probability = this.getDiscreteProblem().prob(stateI, stateJ, action);
                    double coefficient = (stateI.equals(stateJ) ? 1.0 : 0.0) - this.discountFactor * probability;
                    stateJ = statesI.get(stateJ);
                    String constraintLabel = String.valueOf(stateJ.getIndex());
                    XPRBctr constraint = linearProblem.getCtrByName(constraintLabel);
                    constraint.add(variable.mul(coefficient));
                }
                if (this.isAvg) {
                    constraintNorm.add(variable.mul(1.0));
                }
                ++indexVariables;
            }
        }
        if (this.isAvg) {
            XPRBctr delConstraint = linearProblem.getCtrByName(String.valueOf(0));
            linearProblem.delCtr(delConstraint);
        }
        linearProblem.setObj(objectiveFunction);
    }

    private ValueFunction<S> buildValueFunction(XPRBprob linearProblem) {
        int indexStates = 0;
        StatesSet states = this.getDiscreteProblem().getAllStates();
        if (this.discountFactor < 1.0) {
            for (State state : states) {
                double dualValue = 0.0;
                dualValue = linearProblem.getCtrByName(String.valueOf(indexStates)).getDual();
                this.valueFunction.set(state, dualValue);
                ++indexStates;
            }
        } else {
            double gain = linearProblem.getObjVal();
            for (State state : states) {
                this.valueFunction.set(state, gain);
            }
        }
        return this.valueFunction;
    }

    private DecisionRule<S, A> computeDecisionRule(XPRBprob linearProblem) {
        DecisionRule<State, Action> decisionRule = new DecisionRule<State, Action>();
        StatesSet states = this.getDiscreteProblem().getAllStates();
        int notTransient = 0;
        int indexVariables = 0;
        for (State state : states) {
            Actions actions = ((InfiniteMDP)this.getProblem()).feasibleActions(state);
            notTransient = 0;
            for (Action action : actions) {
                double answer = linearProblem.getVarByName(String.valueOf(indexVariables)).getSol();
                if (answer > 0.0) {
                    ++notTransient;
                    decisionRule.set(state, action);
                }
                ++indexVariables;
            }
            if (notTransient != 0) continue;
            Iterator actionsIterator = actions.iterator();
            decisionRule.set(state, (Action)actionsIterator.next());
        }
        return decisionRule;
    }

    @Override
    public String label() {
        return "BCL Solver" + (this.isAvg ? " (avg)" : " (disc)");
    }

    @Override
    public String description() {
        StringBuffer buf = new StringBuffer();
        if (this.isAvg) {
            buf.append("Linear Programming Solver (BCL) for Average Cost Problem");
        } else {
            buf.append("Linear Programming Solver (BCL) for Discounted Cost Problem");
            buf.append(", discount Factor = " + this.discountFactor);
        }
        return buf.toString();
    }

    @Override
    public long getProcessTime() {
        return this.processTime;
    }

    @Override
    public long getBuildTime() {
        return this.buildTime;
    }

    @Override
    public long getLpSolveTime() {
        return this.lpSolveTime;
    }

    @Override
    public long getSolBuildTime() {
        return this.solBuildTime;
    }

    @Override
    public void solveLP() throws SolverException {
        this.solveResult = this.linearProblem.minim("");
    }

    @Override
    public Solution<S, A> buildSolution() throws SolverException {
        this.solved = true;
        DecisionRule<S, A> decisionRule = null;
        this.policy = new Policy(decisionRule);
        decisionRule = this.computeDecisionRule(this.linearProblem);
        this.policy.setDecisionRule(decisionRule);
        this.valueFunction = this.buildValueFunction(this.linearProblem);
        return new Solution(this.valueFunction, this.policy);
    }
}

