/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp.solvers;

import jmarkov.basic.Action;
import jmarkov.basic.Solution;
import jmarkov.basic.State;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.solvers.AbstractAverageSolver;
import jmarkov.jmdp.solvers.LPBCLDiscountedSolver;

public class LPBCLAverageSolver<S extends State, A extends Action>
extends AbstractAverageSolver<S, A> {
    private long processTime = -1L;
    private long buildTime = -1L;
    protected long lpSolveTime = -1L;
    private long solBuildTime = -1L;

    public LPBCLAverageSolver(DTMDP<S, A> problem) {
        super(problem);
    }

    @Override
    public long getIterations() {
        return 0L;
    }

    @Override
    public Solution<S, A> solve() throws SolverException {
        LPBCLDiscountedSolver discSolver = new LPBCLDiscountedSolver(this.getDiscreteProblem());
        discSolver.printValueFunction = this.printValueFunction;
        discSolver.printProcessTime = this.printProcessTime;
        Solution answer = discSolver.solve();
        this.solved = true;
        this.buildTime = discSolver.getBuildTime();
        this.lpSolveTime = discSolver.getLpSolveTime();
        this.solBuildTime = discSolver.getBuildTime();
        this.processTime = discSolver.getProcessTime();
        return answer;
    }

    @Override
    public String label() {
        return "BCL Solver (avg)";
    }

    @Override
    public long getProcessTime() {
        return this.processTime;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public long getLpSolveTime() {
        return this.lpSolveTime;
    }

    public long getSolBuildTime() {
        return this.solBuildTime;
    }
}

