/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp.solvers;

import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.DecisionRule;
import jmarkov.basic.Policy;
import jmarkov.basic.Solution;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.ValueFunction;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.FiniteMDP;
import jmarkov.jmdp.solvers.AbstractFiniteSolver;

public class FiniteSolver<S extends State, A extends Action>
extends AbstractFiniteSolver<S, A> {
    private long processTime = 0L;

    public FiniteSolver(FiniteMDP<S, A> problem) {
        super(problem);
        this.policy = new Policy(((FiniteMDP)this.getProblem()).getHorizon());
    }

    @Override
    public final Solution<S, A> solve() {
        this.init();
        int t = ((FiniteMDP)this.getProblem()).getHorizon() - 1;
        while (t >= 0) {
            this.compute(t);
            --t;
        }
        this.solved = true;
        return new Solution(this.valueFunction, this.policy);
    }

    protected final double future(S i, A a, int t) throws NullPointerException {
        double sum = 0.0;
        States<S> reachableStates = ((FiniteMDP)this.getProblem()).reachable(i, a, t);
        for (State j : reachableStates) {
            sum += ((FiniteMDP)this.getProblem()).prob(i, j, a, t) * this.getValueFunction().get(j);
        }
        return sum;
    }

    private void init() {
        States st = ((FiniteMDP)this.getProblem()).getStates(((FiniteMDP)this.getProblem()).getHorizon());
        this.policy = new Policy(((FiniteMDP)this.getProblem()).getHorizon());
        for (State i : st) {
            double cost = ((FiniteMDP)this.getProblem()).finalCost(i);
            this.valueFunction.set(i, cost);
            this.getProblem().debug(4, "Final cost for state " + i + " set at " + cost);
        }
    }

    private void compute(int t) {
        States st = ((FiniteMDP)this.getProblem()).getStates(t);
        DecisionRule<State, Action> decisionRuleCompute = new DecisionRule<State, Action>();
        ValueFunction<State> vF = new ValueFunction<State>();
        double val = 0.0;
        for (State i : st) {
            Actions act = ((FiniteMDP)this.getProblem()).feasibleActions(i, t);
            this.getProblem().debug(4, "Actions found for state " + i + ":" + act);
            Action Best_a = null;
            double minSoFar = Double.MAX_VALUE;
            for (Action a : act) {
                try {
                    val = this.getProblem().operation(((FiniteMDP)this.getProblem()).immediateCost(i, a, t), this.future(i, a, t));
                }
                catch (NullPointerException e) {
                    continue;
                }
                if (!(val < minSoFar)) continue;
                minSoFar = val;
                Best_a = a;
            }
            vF.set(i, minSoFar);
            decisionRuleCompute.set(i, Best_a);
        }
        this.policy.setDecisionRule(decisionRuleCompute, t);
        this.valueFunction = vF;
    }

    public String bestPolicy(S initial) throws SolverException {
        StringBuffer buf = new StringBuffer(40);
        buf.append("*** Best Policy (starting in " + initial + " )***\n");
        buf.append(this.print(initial, 0));
        return buf.toString();
    }

    private StringBuffer print(S i, int t) throws SolverException {
        StringBuffer str = new StringBuffer(100);
        Policy pol = this.getProblem().getOptimalPolicy();
        if (t < ((FiniteMDP)this.getProblem()).getHorizon()) {
            Object a = pol.getAction(i, t);
            str.append("Stage: " + t);
            str.append(" State: " + i);
            str.append(" Take Action: " + a + "\n");
            States<S> sttes = ((FiniteMDP)this.getProblem()).reachable(i, a, t);
            for (State j : sttes) {
                str.append(this.print(j, t + 1));
            }
        }
        return str;
    }

    @Override
    public final long getProcessTime() {
        return this.processTime;
    }

    @Override
    public String label() {
        return "Default Finite horizon solver";
    }
}

