/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp.solvers;

import jmarkov.basic.Action;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.ValueFunction;
import jmarkov.jmdp.CTMDP;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.solvers.AbstractInfiniteSolver;

public abstract class AbstractDiscountedSolver<S extends State, A extends Action>
extends AbstractInfiniteSolver<S, A> {
    protected double discountFactor = -1.0;

    protected AbstractDiscountedSolver(DTMDP<S, A> problem, double interestRate) {
        super(problem);
        this.setInterestRate(interestRate);
    }

    protected AbstractDiscountedSolver(CTMDP<S, A> problem, double interestRate) {
        super(problem);
        this.discountFactor = problem.getMaxRate() / (interestRate + problem.getMaxRate());
    }

    public final void setInterestRate(double interestRate) {
        if (interestRate < 0.0) {
            throw new IllegalArgumentException("The interest rate must be positive.");
        }
        double newDiscountFactor = 1.0 / (1.0 + interestRate);
        if (newDiscountFactor != this.discountFactor) {
            this.policy = null;
            this.valueFunction = new ValueFunction();
        }
        this.discountFactor = newDiscountFactor;
    }

    public double getInterestRate() {
        return 1.0 / this.discountFactor - 1.0;
    }

    protected final void setDiscountFactor(double discountFactor) {
        if (this.discountFactor != discountFactor) {
            this.policy = null;
        }
        this.discountFactor = discountFactor;
    }

    protected final double future(S i, A a, double discountF, ValueFunction<S> vf) {
        double sum = 0.0;
        States reachableStates = this.getDiscreteProblem().reachable(i, a);
        for (State j : reachableStates) {
            sum += this.getDiscreteProblem().prob((State)i, j, a) * vf.get(j);
        }
        return discountF * sum;
    }

    protected final double future(S i, A a, double discountF) {
        return this.future(i, a, discountF, this.getValueFunction());
    }
}

