/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp;

import java.io.PrintWriter;
import jmarkov.DebugReporter;
import jmarkov.basic.Action;
import jmarkov.basic.Policy;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.ValueFunction;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.solvers.Solver;

public abstract class MDP<S extends State, A extends Action> {
    protected boolean finite = false;
    protected States<S> initial;
    private Solver<S, A> solver = null;
    protected DebugReporter reporter = new DebugReporter(1);

    public final Policy<S, A> getOptimalPolicy() throws SolverException {
        return this.getSolver().getOptimalPolicy();
    }

    public final boolean isSolved() {
        return this.getSolver().isSolved();
    }

    public final boolean isFinite() {
        return this.finite;
    }

    public final void solve() throws SolverException {
        if (this.solver == null) {
            this.solver = this.getDefaultSolver();
        }
        this.solver.solve();
    }

    public Solver<S, A> getSolver() {
        if (this.solver == null) {
            this.solver = this.getDefaultSolver();
        }
        return this.solver;
    }

    public void setSolver(Solver<S, A> solver) {
        this.solver = solver;
        this.reporter.debug(3, "Solver set to " + solver);
    }

    protected abstract Solver<S, A> getDefaultSolver();

    public ValueFunction<S> getOptimalValueFunction() throws SolverException {
        return this.getSolver().getOptimalValueFunction();
    }

    public double operation(double present, double future) {
        return present + future;
    }

    public DebugReporter getReporter() {
        return this.reporter;
    }

    public void setReporter(DebugReporter reporter) {
        this.reporter = reporter;
    }

    public void debug(int level, String message) {
        this.reporter.debug(level, message);
    }

    public void debug(int level, String s, boolean newline, boolean indent) {
        this.reporter.debug(level, s, newline, indent);
    }

    public void debug(int level, String s, boolean newline) {
        this.reporter.debug(level, s, newline);
    }

    public int getDebugLevel() {
        return this.reporter.getDebugLevel();
    }

    public void setDebugLevel(int level) {
        this.reporter.setDebugLevel(level);
    }

    public void printSolution() {
        PrintWriter pw = new PrintWriter(System.out, true);
        this.printSolution(pw);
    }

    public void printSolution(PrintWriter pw) {
        this.getSolver().printSolution(pw);
    }
}

