/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp;

import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.ValueFunction;
import jmarkov.jmdp.CTMDP;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.MDP;
import jmarkov.jmdp.solvers.AbstractAverageSolver;
import jmarkov.jmdp.solvers.AbstractDiscountedSolver;
import jmarkov.jmdp.solvers.AbstractInfiniteSolver;
import jmarkov.jmdp.solvers.ProbabilitySolver;
import jmarkov.jmdp.solvers.RelativeValueIterationSolver;
import jmarkov.jmdp.solvers.ValueIterationSolver;

public abstract class InfiniteMDP<S extends State, A extends Action>
extends MDP<S, A> {
    protected StatesSet<S> states;
    protected ValueFunction<S> probability;
    protected ProbabilitySolver<S, A> probabilitySolver = null;
    protected boolean hasAbsorbingState = false;
    protected States<S> absorbingStates;
    protected long explorationTime = 0L;
    protected int numStates = -1;

    public InfiniteMDP(States<S> initial) {
        this.finite = false;
        this.initial = initial;
    }

    public abstract Actions<A> feasibleActions(S var1);

    public final int getNumStates() {
        if (this.numStates == -1) {
            this.generate();
        }
        return this.numStates;
    }

    protected abstract StatesSet<S> generate();

    protected void setInterestRate(double interestRate) {
        if (!(this.getSolver() instanceof AbstractDiscountedSolver)) {
            this.setSolver(this.getDefaultDiscountedSolver(interestRate));
        }
        ((AbstractDiscountedSolver)this.getSolver()).setInterestRate(interestRate);
        if (!(this instanceof CTMDP)) {
            ((AbstractDiscountedSolver)this.getSolver()).setInterestRate(interestRate);
        } else if (!(this instanceof DTMDP)) {
            ((AbstractDiscountedSolver)this.getSolver()).setInterestRate(interestRate);
        }
    }

    protected AbstractDiscountedSolver<S, A> getDefaultDiscountedSolver(double interestRate) {
        if (this instanceof CTMDP) {
            return new ValueIterationSolver((CTMDP)this, interestRate);
        }
        if (this instanceof DTMDP) {
            return new ValueIterationSolver((DTMDP)this, interestRate);
        }
        return null;
    }

    protected AbstractAverageSolver<S, A> getDefaultAverageSolver() {
        if (this instanceof CTMDP) {
            return new RelativeValueIterationSolver((CTMDP)this);
        }
        if (this instanceof DTMDP) {
            return new RelativeValueIterationSolver((DTMDP)this);
        }
        return null;
    }

    @Override
    protected AbstractInfiniteSolver<S, A> getDefaultSolver() {
        return this.getDefaultAverageSolver();
    }

    public StatesSet<S> getAllStates() {
        if (this.states == null) {
            this.states = this.generate();
        }
        if (!this.states.isClosed()) {
            this.states.numerateStates();
        }
        return this.states;
    }

    @Override
    public AbstractInfiniteSolver<S, A> getSolver() {
        return (AbstractInfiniteSolver)super.getSolver();
    }
}

