/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp;

import jmarkov.basic.Action;
import jmarkov.basic.Event;
import jmarkov.basic.Events;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.jmdp.FiniteMDP;

public abstract class FiniteMDPEv<S extends State, A extends Action, E extends Event>
extends FiniteMDP<S, A> {
    public FiniteMDPEv(States<S> initial, int horizon) {
        super(initial, horizon);
    }

    @Override
    public double immediateCost(S i, A a, int t) {
        double sum = 0.0;
        Events<E> eventSet = this.activeEvents(i, a, t);
        for (Event e : eventSet) {
            sum += this.prob(i, e, t) * this.immediateCost(i, a, e, t);
        }
        return sum;
    }

    public abstract double immediateCost(S var1, A var2, E var3, int var4);

    @Override
    public double prob(S i, S j, A a, int t) {
        double sum = 0.0;
        Events<E> eventSet = this.activeEvents(i, a, t);
        for (Event e : eventSet) {
            sum += this.prob(i, j, a, e, t) * this.prob(i, e, t);
        }
        return sum;
    }

    public abstract double prob(S var1, S var2, A var3, E var4, int var5);

    public abstract double prob(S var1, E var2, int var3);

    @Override
    public States<S> reachable(S i, A a, int t) {
        Events<E> eventSet = this.activeEvents(i, a, t);
        StatesSet<State> statesSet = new StatesSet<State>();
        for (Event e : eventSet) {
            States<S> reached = this.reachable(i, a, e, t);
            for (State s : reached) {
                statesSet.add(s);
            }
        }
        return statesSet;
    }

    public abstract States<S> reachable(S var1, A var2, E var3, int var4);

    public abstract Events<E> activeEvents(S var1, A var2, int var3);
}

