/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp;

import jmarkov.basic.Action;
import jmarkov.basic.Event;
import jmarkov.basic.Events;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.jmdp.DTMDP;

public abstract class DTMDPEv<S extends State, A extends Action, E extends Event>
extends DTMDP<S, A> {
    public DTMDPEv(States<S> initial) {
        super(initial);
    }

    @Override
    public final double immediateCost(S i, A a) {
        double sum = 0.0;
        Events<E> eventSet = this.activeEvents(i, a);
        for (Event e : eventSet) {
            sum += this.prob(i, e) * this.immediateCost(i, a, e);
        }
        return sum;
    }

    @Override
    public final double prob(S i, S j, A a) {
        double sum = 0.0;
        Events<E> eventSet = this.activeEvents(i, a);
        for (Event e : eventSet) {
            sum += this.prob(i, j, a, e) * this.prob(i, e);
        }
        return sum;
    }

    @Override
    public final States<S> reachable(S i, A a) {
        Events<E> eventSet = this.activeEvents(i, a);
        StatesSet<State> statesSet = new StatesSet<State>();
        for (Event e : eventSet) {
            States<S> reached = this.reachable(i, a, e);
            for (State s : reached) {
                statesSet.add(s);
            }
        }
        return statesSet;
    }

    public abstract double immediateCost(S var1, A var2, E var3);

    public abstract double prob(S var1, S var2, A var3, E var4);

    public abstract double prob(S var1, E var2);

    public abstract States<S> reachable(S var1, A var2, E var3);

    public abstract Events<E> activeEvents(S var1, A var2);
}

