/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp;

import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.DecisionRule;
import jmarkov.basic.Solution;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.ValueFunction;
import jmarkov.basic.exceptions.NonStochasticException;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.InfiniteMDP;
import jmarkov.jmdp.solvers.AbstractDiscountedSolver;
import jmarkov.jmdp.solvers.ProbabilitySolver;

public abstract class DTMDP<S extends State, A extends Action>
extends InfiniteMDP<S, A> {
    public DTMDP(States<S> initial) {
        super(initial);
    }

    public DTMDP(S initial) {
        this(new StatesSet<S>(initial));
    }

    public abstract double immediateCost(S var1, A var2);

    public abstract double prob(S var1, S var2, A var3);

    public abstract States<S> reachable(S var1, A var2);

    protected StatesSet<S> oneStageReachable(States<S> initSet) {
        StatesSet<State> stts = new StatesSet<State>();
        for (State i : initSet) {
            Actions act = this.feasibleActions(i);
            for (Action a : act) {
                States<State> reached = this.reachable(i, a);
                double sum = 0.0;
                for (State j : reached) {
                    stts.add(j);
                    sum += this.prob(i, j, a);
                }
                if (!(Math.abs(sum - 1.0) > 1.0E-5)) continue;
                throw new NonStochasticException("Non stochastic row of matrix for state " + i + " and action " + a + ". Sum = " + sum);
            }
        }
        return stts;
    }

    @Override
    protected StatesSet<S> generate() {
        StatesSet unexplored = new StatesSet(this.initial);
        StatesSet<State> explored = new StatesSet<State>();
        long initialTime = System.currentTimeMillis();
        while (unexplored.size() > 0) {
            StatesSet<State> stts = this.oneStageReachable(unexplored);
            for (State s : unexplored) {
                explored.add(s);
            }
            for (State s : explored) {
                stts.remove(s);
            }
            unexplored = stts;
        }
        this.explorationTime = System.currentTimeMillis() - initialTime;
        this.debug(1, String.valueOf(explored.size()) + " states found.\n");
        this.numStates = explored.numerateStates();
        return explored;
    }

    public ValueFunction<S> getSteadyStateProbabilities() throws SolverException {
        if (this.probabilitySolver == null) {
            DecisionRule dr = this.getOptimalPolicy().getDecisionRule();
            this.probabilitySolver = new ProbabilitySolver(this, dr);
        }
        if (!this.probabilitySolver.isSolved()) {
            this.probabilitySolver.solve();
            this.probability = this.probabilitySolver.getProbability();
        }
        return this.probability;
    }

    public void setProbabilitySolver(ProbabilitySolver<S, A> solv) {
        this.probabilitySolver = solv;
    }

    public final Solution<S, A> solve(double interestRate) throws SolverException {
        if (!(this.getSolver() instanceof AbstractDiscountedSolver)) {
            this.setSolver(this.getDefaultDiscountedSolver(interestRate));
        }
        ((AbstractDiscountedSolver)this.getSolver()).setInterestRate(interestRate);
        return this.getSolver().solve();
    }
}

