/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp;

import jmarkov.basic.Action;
import jmarkov.basic.Event;
import jmarkov.basic.Events;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.jmdp.CTMDP;

public abstract class CTMDPEv<S extends State, A extends Action, E extends Event>
extends CTMDP<S, A> {
    public CTMDPEv(States<S> initial) {
        super(initial);
    }

    private double prob(S i, A a, E e) {
        States<S> st = this.reachable(i, a);
        double sum = 0.0;
        for (State s : st) {
            sum += this.rate(i, s, a, e);
        }
        return sum / this.converter.exitRate(i, a);
    }

    @Override
    public final double lumpCost(S i, A a) {
        double sum = 0.0;
        Events<E> eventSet = this.activeEvents(i, a);
        for (Event e : eventSet) {
            sum += this.prob(i, a, e) * this.lumpCost(i, a, e);
        }
        return sum;
    }

    @Override
    public final double continuousCost(S i, A a) {
        double sum = 0.0;
        Events<E> eventSet = this.activeEvents(i, a);
        for (Event e : eventSet) {
            sum += this.prob(i, a, e) * this.continuousCost(i, a, e);
        }
        return sum;
    }

    @Override
    public final double rate(S i, S j, A a) {
        double sum = 0.0;
        Events<E> eventSet = this.activeEvents(i, a);
        for (Event e : eventSet) {
            sum += this.rate(i, j, a, e);
        }
        return sum;
    }

    @Override
    public final States<S> reachable(S i, A a) {
        Events<E> eventSet = this.activeEvents(i, a);
        StatesSet<State> statesSet = new StatesSet<State>();
        for (Event e : eventSet) {
            States<S> reached = this.reachable(i, a, e);
            for (State s : reached) {
                statesSet.add(s);
            }
        }
        return statesSet;
    }

    public abstract double rate(S var1, S var2, A var3, E var4);

    public abstract States<S> reachable(S var1, A var2, E var3);

    public abstract Events<E> activeEvents(S var1, A var2);

    public abstract double lumpCost(S var1, A var2, E var3);

    public abstract double continuousCost(S var1, A var2, E var3);
}

