/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.jmdp.CTMDP;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.solvers.AbstractDiscountedSolver;

public class CT2DTConverter<S extends State, A extends Action>
extends DTMDP<S, A> {
    private double interestRate = -1.0;
    private Map<A, Double> exitRates = null;
    private S activeState;
    private CTMDP<S, A> problem;

    public CT2DTConverter(CTMDP<S, A> problem) {
        super(problem.initial);
        Iterator iterator;
        this.problem = problem;
        problem.setConverter(this);
        if (this.initial != null && (iterator = this.initial.iterator()).hasNext()) {
            State s = (State)iterator.next();
            this.activeState = s;
        }
    }

    public double exitRate(S i, A a) {
        double rate;
        if (((State)i).equals(this.activeState) && this.exitRates.containsKey(a) && (rate = this.exitRates.get(a).doubleValue()) > 0.0) {
            return rate;
        }
        this.activeState = i;
        double exitRate = 0.0;
        States<S> reached = this.problem.reachable(i, a);
        for (State s : reached) {
            exitRate += this.problem.rate((State)i, s, a);
        }
        this.exitRates.put(a, exitRate);
        return exitRate;
    }

    @Override
    public final double immediateCost(S i, A a) {
        if (this.interestRate < 0.0) {
            this.interestRate = !(this.getSolver() instanceof AbstractDiscountedSolver) ? ((AbstractDiscountedSolver)this.problem.getSolver()).getInterestRate() : 0.0;
        }
        return this.problem.lumpCost(i, a) + this.problem.continuousCost(i, a) / (this.interestRate + this.exitRate(i, a));
    }

    @Override
    public final States<S> reachable(S i, A a) {
        final States<S> reached = this.problem.reachable(i, a);
        this.exitRates = new TreeMap<A, Double>();
        return new States<S>((State)i){
            private final /* synthetic */ State val$i;
            {
                this.val$i = state;
            }

            @Override
            public Iterator<S> iterator() {
                return new Iterator<S>(){
                    private boolean wasAdded = false;
                    private boolean justAdded = false;
                    private S theNext = null;

                    @Override
                    public boolean hasNext() {
                        return !this.wasAdded || reached.iterator().hasNext();
                    }

                    @Override
                    public S next() {
                        if (!this.justAdded) {
                            this.theNext = (State)reached.iterator().next();
                        }
                        if (!this.wasAdded && ((State)this.theNext).compareTo(val$i) == -1) {
                            this.wasAdded = true;
                            this.justAdded = true;
                            return val$i;
                        }
                        this.justAdded = false;
                        return this.theNext;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Method not supported");
                    }
                };
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException("Method not supported");
            }

            @Override
            public int numerateStates() {
                throw new UnsupportedOperationException("Method not supported");
            }

            @Override
            public boolean isClosed() {
                return true;
            }
        };
    }

    @Override
    public final double prob(S i, S j, A a) {
        if (i != j) {
            return this.problem.rate(i, j, a) / this.problem.getMaxRate();
        }
        return 1.0 - this.exitRate(i, a) / this.problem.getMaxRate();
    }

    @Override
    public final Actions<A> feasibleActions(S i) {
        return this.problem.feasibleActions(i);
    }

    private Map<A, Double> getExitRates() {
        return this.exitRates;
    }

    void setExitRates(TreeMap<A, Double> exitRates) {
        this.exitRates = exitRates;
    }
}

