/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import jmarkov.gui.GuiUtils;
import jmarkov.gui.InfoPanel;

public class TextPanel
extends InfoPanel
implements ActionListener {
    private static final long serialVersionUID = 1969L;
    JTextArea txtArea = null;
    JButton btnSave = null;
    JButton btnClear = null;
    JButton btnCopy = null;
    static JFileChooser fc = null;
    String title = "";
    boolean autoShow = false;

    public TextPanel(String title) {
        this(title, "", 0, 0);
    }

    private TextPanel(String title, int rows, int cols) {
        this(title, "", rows, cols);
    }

    private TextPanel(String title, String text, int rows, int cols) {
        this.title = title;
        String ImgLoc = "/jmarkov/gui/images/";
        ImageIcon icnSave = null;
        ImageIcon icnClear = null;
        ImageIcon icnCopy = null;
        try {
            icnSave = GuiUtils.createIcon(String.valueOf(ImgLoc) + "Save16.gif");
            icnClear = GuiUtils.createIcon(String.valueOf(ImgLoc) + "Delete16.gif");
            icnCopy = GuiUtils.createIcon(String.valueOf(ImgLoc) + "Copy16.gif");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        JToolBar toolbar = new JToolBar(1);
        this.btnSave = new JButton(icnSave);
        this.btnSave.setToolTipText("Saves the File");
        toolbar.add(this.btnSave);
        this.btnSave.addActionListener(this);
        this.btnClear = new JButton(icnClear);
        this.btnClear.setToolTipText("Clears the log");
        this.btnClear.addActionListener(this);
        toolbar.add(this.btnClear);
        this.btnCopy = new JButton(icnCopy);
        this.btnCopy.setToolTipText("Copy selected text to the clipboard");
        this.btnCopy.addActionListener(this);
        toolbar.add(this.btnCopy);
        toolbar.setFloatable(false);
        this.txtArea = new JTextArea(text, rows, cols);
        this.txtArea.setEditable(false);
        this.txtArea.setFont(new Font("Courier New", 0, 12));
        JScrollPane areaScrollPane = new JScrollPane(this.txtArea);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)toolbar, "East");
        this.add((Component)areaScrollPane, "Center");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.setText(text);
    }

    public void setText(String s) {
        this.setText(s, true);
    }

    public void setText(String s, boolean showText) {
        this.txtArea.setText(s);
        if (showText) {
            this.showTxt();
        }
    }

    public void append(String s) {
        this.append(s, this.autoShow);
    }

    public void append(String s, boolean showText) {
        this.txtArea.append(s);
        if (showText) {
            this.showTxt();
        }
    }

    public String getText() {
        return this.txtArea.getText();
    }

    public void showTxt() {
        Container papi = this.getParent();
        Container nene = this;
        while (papi != null) {
            if (papi instanceof JTabbedPane) {
                ((JTabbedPane)papi).setSelectedComponent(nene);
            }
            nene = papi;
            papi = papi.getParent();
        }
        this.txtArea.setCaretPosition(this.txtArea.getDocument().getLength());
        this.txtArea.getCaret().setSelectionVisible(true);
        this.txtArea.revalidate();
        this.txtArea.repaint();
        Thread.yield();
    }

    public OutputStream getStream() {
        return new StreamCapturer();
    }

    public void captureStandardOut() {
        StreamCapturer sc = new StreamCapturer(System.out);
        System.setOut(new PrintStream(sc));
    }

    public void captureStandardErr() {
        StreamCapturer sc = new StreamCapturer(System.err);
        System.setErr(new PrintStream(sc));
    }

    public void captureStream(PrintStream out) {
        StreamCapturer sc = new StreamCapturer(out);
        System.setOut(new PrintStream(sc));
    }

    void oldCaptureStandarIO() {
        PrintStream originalOut = System.out;
        try {
            PipedOutputStream wtr = new PipedOutputStream();
            PipedInputStream rdr = new PipedInputStream(wtr);
            System.setOut(new PrintStream(wtr));
            new PipeThread(new BufferedReader(new InputStreamReader(rdr))).start();
        }
        catch (IOException ioe) {
            originalOut.println(ioe);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnClear) {
            this.clear();
        }
        if (e.getSource() == this.btnSave) {
            this.saveFile();
        }
        if (e.getSource() == this.btnCopy) {
            if (this.txtArea.getSelectionEnd() == this.txtArea.getSelectionStart()) {
                this.txtArea.selectAll();
            }
            this.txtArea.copy();
        }
    }

    public void clear() {
        this.txtArea.setText("");
    }

    public void saveFile() {
        if (fc == null) {
            fc = new JFileChooser();
        }
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String path = f.getAbsolutePath();
                return path.endsWith("txt") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Text Files (*.txt) ";
            }
        });
        String path = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + this.title + ".txt";
        fc.setSelectedFile(new File(path));
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(file));
                this.txtArea.write(out);
                ((Writer)out).close();
            }
            catch (IOException e) {
                System.out.println("Error writing fle " + file);
            }
        }
    }

    public boolean isAutoShow() {
        return this.autoShow;
    }

    public void setAutoShow(boolean show) {
        this.autoShow = show;
    }

    @Override
    public void updateMP() {
        if (this.mp == null) {
            this.setText("");
        }
    }

    class PipeThread
    extends Thread {
        private BufferedReader in;

        public PipeThread(BufferedReader in) {
            super("PipeThread");
            this.in = null;
            this.in = in;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    class StreamCapturer
    extends OutputStream {
        boolean keepold = false;
        PrintStream oldStream = null;

        public StreamCapturer() {
        }

        public StreamCapturer(PrintStream ps) {
            this(ps, false);
        }

        public StreamCapturer(PrintStream ps, boolean keepold) {
            this.keepold = keepold;
            this.oldStream = ps;
        }

        public void print(String s) {
            if (this.keepold) {
                this.oldStream.print(s);
            }
            TextPanel.this.append(s);
        }

        public void println(String s) {
            if (this.keepold) {
                this.oldStream.println(s);
            }
            TextPanel.this.append(String.valueOf(s) + "\n");
        }

        public void println() {
            if (this.keepold) {
                this.oldStream.println();
            }
            TextPanel.this.append("\n");
        }

        public void print(boolean b) {
            if (this.keepold) {
                this.oldStream.print(b);
            }
            TextPanel.this.append(new Boolean(b).toString());
        }

        public void print(char c) {
            if (this.keepold) {
                this.oldStream.print(c);
            }
            TextPanel.this.append(new String(new char[]{c}));
        }

        public void print(char[] s) {
            if (this.keepold) {
                this.oldStream.print(s);
            }
            TextPanel.this.append(new String(s).toString());
        }

        public void print(double d) {
            if (this.keepold) {
                this.oldStream.print(d);
            }
            TextPanel.this.append(new Double(d).toString());
        }

        public void print(float f) {
            if (this.keepold) {
                this.oldStream.print(f);
            }
            TextPanel.this.append(new Float(f).toString());
        }

        public void print(int i) {
            if (this.keepold) {
                this.oldStream.print(i);
            }
            TextPanel.this.append(new Integer(i).toString());
        }

        public void print(long l) {
            if (this.keepold) {
                this.oldStream.print(l);
            }
            TextPanel.this.append(new Long(l).toString());
        }

        public void print(Object obj) {
            if (this.keepold) {
                this.oldStream.print(obj);
            }
            TextPanel.this.append(obj.toString());
        }

        public void println(boolean b) {
            if (this.keepold) {
                this.oldStream.println(b);
            }
            TextPanel.this.append(String.valueOf(new Boolean(b).toString()) + "\n");
        }

        public void println(char c) {
            if (this.keepold) {
                this.oldStream.println(c);
            }
            TextPanel.this.append(String.valueOf(new String(new char[]{c})) + "\n");
        }

        public void println(char[] s) {
            if (this.keepold) {
                this.oldStream.println(s);
            }
            TextPanel.this.append(String.valueOf(new String(s).toString()) + "\n");
        }

        public void println(double d) {
            if (this.keepold) {
                this.oldStream.println(d);
            }
            TextPanel.this.append(String.valueOf(new Double(d).toString()) + "\n");
        }

        public void println(float f) {
            if (this.keepold) {
                this.oldStream.println(f);
            }
            TextPanel.this.append(String.valueOf(new Float(f).toString()) + "\n");
        }

        public void println(int i) {
            if (this.keepold) {
                this.oldStream.println(i);
            }
            TextPanel.this.append(String.valueOf(new Integer(i).toString()) + "\n");
        }

        public void println(long l) {
            if (this.keepold) {
                this.oldStream.println(l);
            }
            TextPanel.this.append(String.valueOf(new Long(l).toString()) + "\n");
        }

        public void println(Object obj) {
            if (this.keepold) {
                this.oldStream.println(obj);
            }
            TextPanel.this.append(String.valueOf(obj.toString()) + "\n");
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            if (this.keepold) {
                this.oldStream.write(buf, off, len);
            }
            TextPanel.this.append(new String(buf, off, len));
        }

        @Override
        public void write(int b) {
            if (this.keepold) {
                this.oldStream.write(b);
            }
            TextPanel.this.append(new String(new byte[]{(byte)b}));
        }
    }
}

