/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jmarkov.MarkovProcess;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.Event;
import jmarkov.basic.State;
import jmarkov.basic.Transition;
import jmarkov.basic.Transitions;
import jmarkov.basic.exceptions.NotUnichainException;
import jmarkov.gui.GuiUtils;
import jmarkov.gui.InfoPanel;

public class SparseMatrixPanel
extends InfoPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = 1969L;
    private JTree jTree = null;
    private DefaultTreeModel treeModel = null;
    private JScrollPane infoScrollPane = null;
    private boolean showEvents = false;
    private DefaultMutableTreeNode root = null;
    private JSplitPane jSplitPane = null;
    private JScrollPane treeScrollPane = null;
    private JEditorPane treeInfoPanel = null;
    private ImageIcon stateIcon = null;
    private ImageIcon eventIcon = null;
    private ImageIcon modelIcon = null;

    public SparseMatrixPanel() {
        this.initialize();
    }

    public SparseMatrixPanel(boolean showEvents) {
        this.initialize();
        this.showEvents = showEvents;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJSplitPane(), "Center");
        this.stateIcon = GuiUtils.createIcon("/jmarkov/gui/images/GreenBall.gif");
        this.eventIcon = GuiUtils.createIcon("/jmarkov/gui/images/RedSquare.gif");
        this.modelIcon = GuiUtils.createIcon("/jmarkov/gui/images/middle.gif");
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void updateMP() {
        MarkovProcess mp = super.getMP();
        this.root.removeAllChildren();
        if (mp == null) {
            this.root = new DefaultMutableTreeNode("No model loaded");
            this.treeModel.reload();
            this.jTree = null;
            this.treeScrollPane.setViewportView(this.getJTree());
            return;
        }
        State[] states = mp.getStates(false).toStateArray();
        Event[] events = mp.getEvents();
        State[] stateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            State i = stateArray[n2];
            DefaultMutableTreeNode iStateNode = new DefaultMutableTreeNode(i);
            this.root.add(iStateNode);
            if (this.showEvents) {
                Event[] eventArray = events;
                int n3 = events.length;
                int n4 = 0;
                while (n4 < n3) {
                    Event e = eventArray[n4];
                    Transitions<State> trans = mp.activeTransitions(i, e);
                    if (trans.size() != 0) {
                        DefaultMutableTreeNode eEventNode = new DefaultMutableTreeNode(e);
                        iStateNode.add(eEventNode);
                        for (Transition tr : trans) {
                            Object j = tr.getState();
                            DefaultMutableTreeNode jStateNode = new DefaultMutableTreeNode(j);
                            eEventNode.add(jStateNode);
                        }
                    }
                    ++n4;
                }
            } else {
                Transitions<State> reachable = mp.getRates(i);
                for (Transition j : reachable) {
                    DefaultMutableTreeNode jStateNode = new DefaultMutableTreeNode(j.getState());
                    iStateNode.add(jStateNode);
                }
            }
            ++n2;
        }
        this.root.setUserObject(mp.getClass().getName());
        this.treeModel.reload();
        this.treeModel.nodeChanged(this.root);
        this.jTree.setRootVisible(true);
        TreePath rootPath = new TreePath(this.root.getPath());
        this.jTree.expandPath(rootPath);
        this.jTree.setSelectionPath(rootPath);
        this.jTree.validate();
    }

    private JTree getJTree() {
        if (this.jTree == null) {
            this.root = new DefaultMutableTreeNode("No data yet ...");
            this.treeModel = new DefaultTreeModel(this.root);
            this.jTree = new JTree(this.treeModel);
            ToolTipManager.sharedInstance().registerComponent(this.jTree);
            this.jTree.setShowsRootHandles(true);
            this.jTree.setName("States Tree");
            this.jTree.setToolTipText("Rates Tree view");
            this.jTree.getSelectionModel().setSelectionMode(1);
            this.jTree.addTreeSelectionListener(this);
            this.jTree.setCellRenderer(new MarkovTreeCellRenderer());
        }
        return this.jTree;
    }

    private JScrollPane getInfoScrollPane() {
        if (this.infoScrollPane == null) {
            this.infoScrollPane = new JScrollPane();
            this.infoScrollPane.setViewportView(this.getTreeInfoPanel());
        }
        return this.infoScrollPane;
    }

    private JEditorPane getTreeInfoPanel() {
        if (this.treeInfoPanel == null) {
            this.treeInfoPanel = new JEditorPane();
            this.treeInfoPanel.setContentType("text/html");
        }
        return this.treeInfoPanel;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setRightComponent(this.getInfoScrollPane());
            this.jSplitPane.setLeftComponent(this.getTreeScrollPane());
            this.jSplitPane.setDividerLocation(400);
            this.jSplitPane.setCursor(new Cursor(0));
        }
        return this.jSplitPane;
    }

    private JScrollPane getTreeScrollPane() {
        if (this.treeScrollPane == null) {
            this.treeScrollPane = new JScrollPane();
            this.treeScrollPane.setViewportView(this.getJTree());
        }
        return this.treeScrollPane;
    }

    @Override
    public void valueChanged(TreeSelectionEvent te) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object ob = node.getUserObject();
        if (node.isLeaf() && ob instanceof State) {
            State j = (State)ob;
            if (this.showEvents) {
                DefaultMutableTreeNode eNode = (DefaultMutableTreeNode)node.getParent();
                Event e = (Event)eNode.getUserObject();
                DefaultMutableTreeNode iNode = (DefaultMutableTreeNode)eNode.getParent();
                State i = (State)iNode.getUserObject();
                this.showInformation(i, j, e);
            } else {
                DefaultMutableTreeNode iNode = (DefaultMutableTreeNode)node.getParent();
                State i = (State)iNode.getUserObject();
                this.showInformation(i, j);
            }
        } else if (ob instanceof State) {
            State i = (State)ob;
            this.showInformation(i);
        } else if (ob instanceof Event) {
            Event e = (Event)ob;
            DefaultMutableTreeNode iNode = (DefaultMutableTreeNode)node.getParent();
            State i = (State)iNode.getUserObject();
            this.showInformation(i, e);
        } else if (this.mp != null) {
            this.showInformation(this.mp);
        }
    }

    private void showInformation(State i, State j, Event e) {
        String stg = "<html>";
        stg = String.valueOf(stg) + "<font color=+2 color=red>Origin: </font><br>";
        stg = String.valueOf(stg) + this.stateToHtml(i);
        stg = String.valueOf(stg) + "<font color=+2 color=red>Destination: </font><br>";
        stg = String.valueOf(stg) + this.stateToHtml(j);
        stg = String.valueOf(stg) + "<font color=+2 color=red>Event: </font><br>";
        stg = String.valueOf(stg) + this.eventToHtml(e);
        if (this.mp instanceof SimpleMarkovProcess) {
            SimpleMarkovProcess smp = (SimpleMarkovProcess)this.mp;
            double rate = smp.rate(i, j, e);
            stg = String.valueOf(stg) + "<font color=+2 color=red>Rate = " + rate + "</font><br>";
        }
        stg = String.valueOf(stg) + "</html>";
        this.treeInfoPanel.setText(stg);
    }

    private void showInformation(State i, State j) {
        String stg = "<html>";
        stg = String.valueOf(stg) + "<font color=+2 color=red>Origin:</font><br>";
        stg = String.valueOf(stg) + this.stateToHtml(i);
        stg = String.valueOf(stg) + "<font color=+2 color=red>Destination:</font><br>";
        stg = String.valueOf(stg) + this.stateToHtml(j);
        stg = String.valueOf(stg) + "<font color=+2 color=red>Rate = " + this.mp.getRate(i, j) + "</font><br>";
        stg = String.valueOf(stg) + "</html>";
        this.treeInfoPanel.setText(stg);
    }

    private void showInformation(State i, Event e) {
        String stg = "<html>";
        stg = String.valueOf(stg) + this.stateToHtml(i) + this.eventToHtml(e) + "</html>";
        this.treeInfoPanel.setText(stg);
    }

    private void showInformation(State i) {
        String stg = this.stateToHtml(i);
        if (this.mp.isGenerated()) {
            try {
                stg = String.valueOf(stg) + "Steady State Probability = " + this.mp.getSteadyState()[i.getIndex()];
            }
            catch (NotUnichainException e) {
                stg = String.valueOf(stg) + "ERROR!!";
            }
        }
        this.treeInfoPanel.setText(stg);
    }

    private void showInformation(MarkovProcess mp) {
        this.treeInfoPanel.setText("<pre>" + mp.description() + "</pre>");
    }

    private String stateToHtml(State s) {
        String stg = "";
        stg = String.valueOf(stg) + "<font color=blue> State " + s.label() + "</font><br>";
        stg = String.valueOf(stg) + s.description() + "<br>";
        return stg;
    }

    private String eventToHtml(Event e) {
        String stg = "";
        stg = String.valueOf(stg) + "<font color=blue> Event " + e.toString() + "</font><br>";
        return stg;
    }

    class MarkovTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -9073174257320648115L;

        MarkovTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                Object ob = ((DefaultMutableTreeNode)value).getUserObject();
                if (ob instanceof State) {
                    State s = (State)ob;
                    this.setToolTipText(s.description());
                    if (SparseMatrixPanel.this.stateIcon != null) {
                        this.setIcon(SparseMatrixPanel.this.stateIcon);
                    }
                } else if (ob instanceof Event) {
                    Event e = (Event)ob;
                    this.setToolTipText(e.description());
                    if (SparseMatrixPanel.this.eventIcon != null) {
                        this.setIcon(SparseMatrixPanel.this.eventIcon);
                    }
                } else {
                    this.setToolTipText(null);
                    if (SparseMatrixPanel.this.modelIcon != null) {
                        this.setIcon(SparseMatrixPanel.this.modelIcon);
                    }
                }
            }
            return this;
        }
    }
}

