/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import jmarkov.DebugReporter;
import jmarkov.gui.MarkovGUI;

public class MarkovFileOpenDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 19692005L;
    private JPanel pnlMain = null;
    private JPanel pnlMP = null;
    private JPanel pnlEventFile = null;
    private JPanel pnlStateFile = null;
    private JTextField txtMarkovProcessFile = null;
    private JTextField txtEventFile = null;
    private JTextField txtStateFile = null;
    private JLabel lblMarkovProcessFile = null;
    private JLabel lblStateFile = null;
    private JLabel lblEventFile = null;
    private JButton btnMarkovProcess = null;
    private JButton btnStateFile = null;
    private JButton btnEventFile = null;
    private JLabel lblIntro = null;
    private JPanel pnlControls = null;
    private JButton btnOK = null;
    private JButton btnCancel = null;
    private JButton[] btnsArray = null;
    private JTextField[] txtfldArray = null;
    private static String[] fileNames = null;
    private ResultTypes dialogResult = ResultTypes.CANCEL;
    private DebugReporter reporter = null;
    JFileChooser fc = null;

    public MarkovFileOpenDialog() {
        this.setModal(true);
        this.setDefaultCloseOperation(1);
        this.initialize();
    }

    public MarkovFileOpenDialog(DebugReporter reporter, MarkovGUI owner) {
        super(owner, "JMarkov - Choose File", true);
        this.reporter = reporter;
        this.setDefaultCloseOperation(1);
        if (fileNames == null) {
            fileNames = new String[]{"MyMarkovProcessEvent.class", "MyMarkovProcessState.class", "MyMarkovProcess.class"};
        }
        this.initialize();
    }

    public MarkovFileOpenDialog(String[] files, DebugReporter reporter, MarkovGUI owner) {
        this(reporter, owner);
        fileNames = files;
        int i = 0;
        while (i < 3) {
            this.txtfldArray[i].setText(fileNames[i]);
            ++i;
        }
    }

    private void initialize() {
        this.setSize(558, 298);
        this.setContentPane(this.getPnlMain());
        this.setLocationByPlatform(true);
        this.btnsArray = new JButton[]{this.btnEventFile, this.btnStateFile, this.btnMarkovProcess};
        this.txtfldArray = new JTextField[]{this.txtEventFile, this.txtStateFile, this.txtMarkovProcessFile};
        if (fileNames != null) {
            int i = 0;
            while (i < 3) {
                this.txtfldArray[i].setText(fileNames[i]);
                ++i;
            }
        }
        SwingUtilities.updateComponentTreeUI(this);
        this.pack();
    }

    public ResultTypes getDialogResult() {
        return this.dialogResult;
    }

    public String[] getFileNames() {
        fileNames = new String[3];
        int i = 0;
        while (i < 3) {
            MarkovFileOpenDialog.fileNames[i] = this.txtfldArray[i].getText();
            ++i;
        }
        return fileNames;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton btn = (JButton)e.getSource();
        int idx = 0;
        idx = 0;
        while (btn != this.btnsArray[idx] && idx < 3) {
            ++idx;
        }
        if (idx == 3) {
            return;
        }
        String fullName = "";
        File file = null;
        if (this.fc == null) {
            this.fc = new JFileChooser();
            this.fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String path = f.getAbsolutePath();
                    return path.endsWith("class") || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Class Files (*.class) ";
                }
            });
        }
        File currFile = new File(this.txtfldArray[idx].getText());
        String path = currFile.getParent();
        String fileName = currFile.getName();
        String userDir = System.getProperty("user.dir");
        if (path == "" || path == null) {
            path = userDir;
        }
        this.fc.setSelectedFile(new File(path, fileName));
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                file = this.fc.getSelectedFile();
                fullName = file.getParent() == userDir ? file.getName() : file.getCanonicalPath();
                this.txtfldArray[idx].setText(fullName);
            }
            catch (Exception ex) {
                this.reporter.debug(0, "Error openning file " + fullName + "\nException:" + ex);
            }
        }
    }

    private JPanel getPnlMain() {
        if (this.pnlMain == null) {
            this.lblIntro = new JLabel();
            this.lblIntro.setText("Please select the file where the new classes reside:");
            this.lblIntro.setFont(new Font("Dialog", 1, 14));
            this.lblIntro.setHorizontalAlignment(0);
            this.lblIntro.setHorizontalTextPosition(0);
            this.pnlMain = new JPanel();
            this.pnlMain.setLayout(new BoxLayout(this.pnlMain, 1));
            this.pnlMain.add((Component)this.lblIntro, null);
            this.pnlMain.add((Component)this.getPnlMP(), null);
            this.pnlMain.add((Component)this.getPnlStateFile(), null);
            this.pnlMain.add((Component)this.getPnlEventFile(), null);
            this.pnlMain.add((Component)this.getPnlControls(), null);
        }
        return this.pnlMain;
    }

    private JPanel getPnlMP() {
        if (this.pnlMP == null) {
            BorderLayout borderLayout5 = new BorderLayout();
            borderLayout5.setHgap(9);
            borderLayout5.setVgap(9);
            this.lblMarkovProcessFile = new JLabel();
            this.lblMarkovProcessFile.setText("SimpleMarkovProcess File:");
            this.lblMarkovProcessFile.setHorizontalAlignment(10);
            this.pnlMP = new JPanel();
            this.pnlMP.setLayout(borderLayout5);
            this.pnlMP.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pnlMP.add((Component)this.getTxtMarkovProcessFile(), "Center");
            this.pnlMP.add((Component)this.getBtnMarkovProcess(), "East");
            this.pnlMP.add((Component)this.lblMarkovProcessFile, "North");
        }
        return this.pnlMP;
    }

    private JTextField getTxtMarkovProcessFile() {
        if (this.txtMarkovProcessFile == null) {
            this.txtMarkovProcessFile = new JTextField();
            this.txtMarkovProcessFile.setText("MyMarkovProcess.class");
            this.txtMarkovProcessFile.setHorizontalAlignment(2);
        }
        return this.txtMarkovProcessFile;
    }

    private JTextField getTxtEventFile() {
        if (this.txtEventFile == null) {
            this.txtEventFile = new JTextField();
            this.txtEventFile.setText("MyEventProcessEvent.class");
        }
        return this.txtEventFile;
    }

    private JButton getBtnMarkovProcess() {
        if (this.btnMarkovProcess == null) {
            this.btnMarkovProcess = new JButton();
            this.btnMarkovProcess.setText("Browse ...");
            this.btnMarkovProcess.setIcon(new ImageIcon(this.getClass().getResource("/jmarkov/gui/images/open.gif")));
            this.btnMarkovProcess.addActionListener(this);
        }
        return this.btnMarkovProcess;
    }

    private JTextField getTxtStateFile() {
        if (this.txtStateFile == null) {
            this.txtStateFile = new JTextField();
            this.txtStateFile.setText("MyMarkovProcessState.class");
        }
        return this.txtStateFile;
    }

    private JPanel getPnlStateFile() {
        if (this.pnlStateFile == null) {
            BorderLayout borderLayout6 = new BorderLayout();
            borderLayout6.setHgap(9);
            borderLayout6.setVgap(9);
            this.lblStateFile = new JLabel();
            this.lblStateFile.setText("State File:");
            this.lblStateFile.setHorizontalAlignment(10);
            this.lblStateFile.setHorizontalTextPosition(4);
            this.pnlStateFile = new JPanel();
            this.pnlStateFile.add((Component)this.getTxtStateFile(), "Center");
            this.pnlStateFile.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pnlStateFile.setLayout(borderLayout6);
            this.pnlStateFile.add((Component)this.getTxtStateFile(), "Center");
            this.pnlStateFile.add((Component)this.getBtnStateFile(), "East");
            this.pnlStateFile.add((Component)this.lblStateFile, "North");
        }
        return this.pnlStateFile;
    }

    private JPanel getPnlEventFile() {
        if (this.pnlEventFile == null) {
            BorderLayout borderLayout7 = new BorderLayout();
            borderLayout7.setHgap(9);
            borderLayout7.setVgap(9);
            this.lblEventFile = new JLabel();
            this.lblEventFile.setText("Event File:");
            this.lblEventFile.setHorizontalAlignment(10);
            this.pnlEventFile = new JPanel();
            this.pnlEventFile.add((Component)this.getTxtEventFile(), "Center");
            this.pnlEventFile.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pnlEventFile.setLayout(borderLayout7);
            this.pnlEventFile.add((Component)this.getTxtEventFile(), "Center");
            this.pnlEventFile.add((Component)this.getBtnEventFile(), "East");
            this.pnlEventFile.add((Component)this.lblEventFile, "North");
        }
        return this.pnlEventFile;
    }

    private JButton getBtnStateFile() {
        if (this.btnStateFile == null) {
            this.btnStateFile = new JButton();
            this.btnStateFile.setText("Browse ...");
            this.btnStateFile.setIcon(new ImageIcon(this.getClass().getResource("/jmarkov/gui/images/open.gif")));
            this.btnStateFile.addActionListener(this);
        }
        return this.btnStateFile;
    }

    private JButton getBtnEventFile() {
        if (this.btnEventFile == null) {
            this.btnEventFile = new JButton();
            this.btnEventFile.setText("Browse ...");
            this.btnEventFile.setIcon(new ImageIcon(this.getClass().getResource("/jmarkov/gui/images/open.gif")));
            this.btnEventFile.addActionListener(this);
        }
        return this.btnEventFile;
    }

    private JPanel getPnlControls() {
        if (this.pnlControls == null) {
            this.pnlControls = new JPanel();
            this.pnlControls.add((Component)this.getBtnOK(), null);
            this.pnlControls.add((Component)this.getBtnCancel(), null);
        }
        return this.pnlControls;
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setText("OK");
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MarkovFileOpenDialog.this.dialogResult = ResultTypes.OK;
                    MarkovFileOpenDialog.this.setVisible(false);
                }
            });
        }
        return this.btnOK;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MarkovFileOpenDialog.this.dialogResult = ResultTypes.CANCEL;
                    MarkovFileOpenDialog.this.setVisible(false);
                }
            });
        }
        return this.btnCancel;
    }

    public static enum ResultTypes {
        OK,
        CANCEL,
        CLOSE;

    }
}

