/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.gui;

import java.awt.Container;
import java.awt.Window;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import jmarkov.gui.MarkovGUI;
import jmarkov.gui.TextPanel;

public class GuiUtils {
    static Hashtable<String, Action> actions;

    public static void changeLook(String lnfName, Window win) {
        try {
            UIManager.setLookAndFeel(lnfName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(win);
        win.pack();
    }

    public static void setTabEnabled(JComponent comp, boolean enabl) {
        Container papi = comp.getParent();
        Container nene = comp;
        int idx = -1;
        while (papi != null) {
            if (papi instanceof JTabbedPane) {
                idx = ((JTabbedPane)papi).indexOfComponent(nene);
                ((JTabbedPane)papi).setEnabledAt(idx, enabl);
                try {
                    if (!enabl) {
                        ((TextPanel)nene).clear();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            nene = papi;
            papi = papi.getParent();
        }
    }

    public static void createActionTable(JTextComponent textComponent) {
        actions = new Hashtable();
        Action[] actionsArray = textComponent.getActions();
        int i = 0;
        while (i < actionsArray.length) {
            Action a = actionsArray[i];
            actions.put((String)a.getValue("Name"), a);
            ++i;
        }
    }

    public static JLabel fancyLabel(String title, String text) {
        JLabel lbl = new JLabel(text);
        lbl.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return lbl;
    }

    public static Action getActionByName(String name) {
        return actions.get(name);
    }

    static ImageIcon createIcon(String location) {
        URL url = MarkovGUI.class.getResource(location);
        return new ImageIcon(url);
    }

    public static JButton getButton(Action a) {
        JButton but = new JButton();
        but.setAction(a);
        if (but.getIcon() != null) {
            but.setText("");
        }
        return but;
    }
}

