/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jmarkov.basic.State;
import jmarkov.gui.InfoPanel;

public class DenseRatesPanel
extends InfoPanel {
    private static final long serialVersionUID = 3278485673228567288L;
    JTable table = null;
    JTable rowHeaders = null;
    String[] columnNames = new String[]{"No data yet ..."};
    JScrollPane scrollPane = null;

    public DenseRatesPanel() {
        MatrixTableModel tableModel = new MatrixTableModel();
        this.table = new JTable(tableModel);
        this.scrollPane = new JScrollPane(this.table, 22, 32);
        this.table.setAutoResizeMode(0);
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.scrollPane);
    }

    @Override
    public void updateMP() {
        if (this.mp == null) {
            return;
        }
        State[] states = this.mp.getStates().toStateArray();
        int N = states.length;
        Object[][] firstRowData = new State[N][1];
        int i = 0;
        while (i < N) {
            firstRowData[i][0] = states[i];
            ++i;
        }
        StatesTableHeader stateRenderer = new StatesTableHeader(states);
        this.rowHeaders = new JTable(firstRowData, new String[]{""});
        TableColumn col0 = this.rowHeaders.getColumnModel().getColumn(0);
        col0.setHeaderRenderer(stateRenderer);
        col0.setCellRenderer(stateRenderer);
        int width = 100;
        int height = this.table.getPreferredSize().height;
        this.rowHeaders.setPreferredScrollableViewportSize(new Dimension(width, height));
        this.scrollPane.setRowHeaderView(this.rowHeaders);
        this.columnNames = new String[N];
        int i2 = 0;
        while (i2 < N) {
            this.columnNames[i2] = states[i2].label();
            ++i2;
        }
        MatrixTableModel tblModel = new MatrixTableModel();
        this.table.setModel(tblModel);
        int i3 = 0;
        while (i3 < N) {
            TableColumn col = this.table.getColumnModel().getColumn(i3);
            col.setMinWidth(50);
            col.setPreferredWidth(100);
            col.setHeaderRenderer(stateRenderer);
            ++i3;
        }
    }

    class MatrixTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2060267097161157594L;

        @Override
        public int getColumnCount() {
            return DenseRatesPanel.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return DenseRatesPanel.this.mp != null ? DenseRatesPanel.this.mp.getNumStates() : 1;
        }

        @Override
        public String getColumnName(int col) {
            return DenseRatesPanel.this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            double val = 0.0;
            if (DenseRatesPanel.this.mp != null) {
                State[] sts = DenseRatesPanel.this.mp.getStates().toStateArray();
                val = DenseRatesPanel.this.mp.getFinalRate(sts[row], sts[col]);
            }
            return val > 0.0 ? new Double(val) : "";
        }

        private Class getColumnClassToDelete(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class StatesTableHeader
    implements TableCellRenderer {
        State[] states;

        public StatesTableHeader(State[] states) {
            this.states = states;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JButton comp = new JButton(value.toString());
            if (this.states != null) {
                if (value instanceof State) {
                    comp.setToolTipText(((State)value).description());
                }
                if (value instanceof String) {
                    comp.setToolTipText(this.states[column].description());
                }
            }
            return comp;
        }
    }
}

