/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.basic;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import jmarkov.basic.State;
import jmarkov.basic.States;

public class StatesSet<S extends State>
implements States<S> {
    private SortedMap<S, S> theSet = new TreeMap<S, S>();
    private boolean closed = false;

    public StatesSet() {
    }

    public StatesSet(S s) {
        this();
        this.add(s);
    }

    public StatesSet(Iterable<S> states) {
        this();
        for (State s : states) {
            this.add(s);
        }
    }

    public StatesSet(S[] states) {
        this();
        S[] SArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            S s = SArray[n2];
            this.add(s);
            ++n2;
        }
    }

    public StatesSet(States<S> states) {
        this();
        for (State s : states) {
            this.add(s);
        }
    }

    @Override
    public final Iterator<S> iterator() {
        return this.theSet.values().iterator();
    }

    public boolean add(S s) {
        if (this.closed) {
            throw new RuntimeException("This set was closed and no new elemns can be added");
        }
        return this.theSet.put(s, s) == null;
    }

    public boolean add(Iterable<S> states) {
        boolean result = true;
        for (State s : states) {
            result &= this.add(s);
        }
        return result;
    }

    public boolean add(States<S> states) {
        boolean result = true;
        for (State s : states) {
            result &= this.add(s);
        }
        return result;
    }

    public S get(S state) {
        return (S)((State)this.theSet.get(state));
    }

    public boolean remove(S s) {
        return this.theSet.remove(s) == null;
    }

    public boolean contains(S s) {
        return this.theSet.containsKey(s);
    }

    @Override
    public int numerateStates() {
        int numStates = 0;
        for (State s : this.theSet.keySet()) {
            s.setIndex(numStates++);
        }
        this.closed = true;
        return numStates;
    }

    public S[] toStateArray() {
        int size = this.theSet.size();
        State[] result = null;
        if (size != 0) {
            State elem = (State)this.theSet.firstKey();
            result = (State[])Array.newInstance(elem.getClass(), size);
            Iterator<S> it = this.theSet.values().iterator();
            int i = 0;
            while (i < size) {
                result[i] = (State)it.next();
                ++i;
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.theSet.size();
    }

    public String toString() {
        return this.theSet.toString();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

