/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.basic;

import jmarkov.MarkovProcess;
import jmarkov.basic.Event;
import jmarkov.basic.State;

public class StateEvent<S extends State, E extends Event>
extends State {
    private S state;
    private E event;

    public StateEvent(S state, E event) {
        this.state = state;
        this.event = event;
    }

    public S getState() {
        return this.state;
    }

    public E getEvent() {
        return this.event;
    }

    @Override
    public String label() {
        return "( " + ((State)this.state).label() + " , " + ((Event)this.event).label() + ")";
    }

    @Override
    public int compareTo(State i) {
        if (!(i instanceof StateEvent)) {
            throw new IllegalArgumentException("Comparing wrong type of Objects");
        }
        StateEvent s1 = (StateEvent)i;
        if (((State)this.state).compareTo((State)s1.getState()) == 0) {
            return ((Event)this.event).compareTo((Event)s1.getEvent());
        }
        return ((State)this.state).compareTo((State)s1.getState());
    }

    @Override
    public boolean isConsistent() {
        return ((State)this.state).isConsistent();
    }

    @Override
    public void computeMOPs(MarkovProcess<?, ?> model) {
        ((State)this.state).computeMOPs(model);
    }
}

