/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.basic;

import java.util.ArrayList;
import java.util.List;
import jmarkov.MarkovProcess;
import jmarkov.basic.JMarkovElement;

public abstract class State
implements Comparable<State>,
JMarkovElement {
    private List<Double> mops = null;
    private int index = -1;

    @Override
    public abstract int compareTo(State var1);

    @Override
    public final boolean equals(Object o) {
        if (!(o instanceof State)) {
            return false;
        }
        State s1 = (State)o;
        return this.compareTo(s1) == 0;
    }

    public final int setMOP(int index, double value) {
        if (this.mops == null) {
            this.mops = new ArrayList<Double>(10);
        }
        while (index >= this.mops.size()) {
            this.mops.add(null);
        }
        this.mops.set(index, new Double(value));
        return index;
    }

    public int setMOP(MarkovProcess<?, ?> model, String mopName, double value) {
        int i = model.getMOPIndex(mopName);
        if (i == -1) {
            model.addMOP(mopName);
            i = model.numMOPs() - 1;
        }
        this.setMOP(i, value);
        return i;
    }

    public abstract void computeMOPs(MarkovProcess<?, ?> var1);

    public final double getMOP(String mopName, MarkovProcess<?, ?> model) {
        int i = model.getMOPIndex(mopName);
        return this.getMOP(i);
    }

    public double getMOP(int index) {
        double val = 0.0;
        try {
            val = this.mops.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("\n  Measure of Performance Number'" + index + "' was never computed for state: " + this);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("\n  Error getting Measure of Performance '" + index + "'  for state: " + this + " " + (this.mops == null ? ". 'mops' is null" : ""));
        }
        return val;
    }

    public abstract boolean isConsistent();

    @Override
    public abstract String label();

    @Override
    public String description() {
        return "";
    }

    @Override
    public final String toString() {
        return this.label();
    }

    public final int getIndex() {
        return this.index;
    }

    final void setIndex(int i) {
        this.index = i;
    }
}

